/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.net;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mobicents.protocols.smpp.message.SMPPPacket;
import org.mobicents.protocols.smpp.net.ReadTimeoutException;
import org.mobicents.protocols.smpp.net.SmscLink;
import org.mobicents.protocols.smpp.util.PacketDecoderImpl;
import org.mobicents.protocols.smpp.util.PacketFactory;
import org.mobicents.protocols.smpp.util.SMPPIO;

public class ReplayLink
implements SmscLink {
    private InputStream inPacketSource;
    private InputStream outPacketSource;
    private int timeout = 0;
    private boolean connected;
    private PacketFactory packetFactory = new PacketFactory();
    private Set<Long> outboundSeqNums = new HashSet<Long>();
    private List<SMPPPacket> packetLookahead = new ArrayList<SMPPPacket>();
    private byte[] header = new byte[16];
    private byte[] packet = new byte[512];
    private TestDecoder decoder = new TestDecoder();

    public ReplayLink(InputStream inPacketSource, InputStream outPacketSource) {
        this.inPacketSource = inPacketSource;
        this.outPacketSource = outPacketSource;
    }

    public void connect() throws IOException {
        this.connected = true;
        this.lookahead(10);
    }

    public void disconnect() throws IOException {
        this.connected = false;
        this.packetLookahead.clear();
    }

    public void flush() throws IOException {
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isTimeoutSupported() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SMPPPacket getNextOutbound() throws IOException {
        TestDecoder testDecoder = this.decoder;
        synchronized (testDecoder) {
            return this.readOnePacket(this.outPacketSource);
        }
    }

    public SMPPPacket read() throws IOException {
        if (!this.connected) {
            throw new IllegalStateException("Not connected.");
        }
        if (this.packetLookahead.size() < 3) {
            this.lookahead(50);
        }
        if (this.packetLookahead.size() == 0) {
            throw new EOFException();
        }
        SMPPPacket entry = this.packetLookahead.get(0);
        Long sequence = new Long(entry.getSequenceNum());
        if (entry.isResponse() && !this.outboundSeqNums.contains(sequence)) {
            this.blockUntilRequestSent(sequence);
        }
        return this.packetLookahead.remove(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(SMPPPacket packet, boolean withOptionalParams) throws IOException {
        if (!this.connected) {
            throw new IllegalStateException("Not connected.");
        }
        Long seq = new Long(packet.getSequenceNum());
        ReplayLink replayLink = this;
        synchronized (replayLink) {
            this.outboundSeqNums.add(seq);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lookahead(int number) throws IOException {
        TestDecoder testDecoder = this.decoder;
        synchronized (testDecoder) {
            SMPPPacket packet;
            for (int i = 0; i < number && (packet = this.readOnePacket(this.inPacketSource)) != null; ++i) {
                this.packetLookahead.add(packet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockUntilRequestSent(Long sequence) {
        try {
            ReplayLink replayLink = this;
            synchronized (replayLink) {
                if (!this.outboundSeqNums.contains(sequence)) {
                    this.wait(this.timeout);
                }
                if (!this.outboundSeqNums.contains(sequence)) {
                    throw new ReadTimeoutException();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private SMPPPacket readOnePacket(InputStream source) throws IOException {
        int count;
        int n;
        for (count = 0; count < 16; count += n) {
            n = source.read(this.header, 0, 16 - count);
            if (n >= 0) continue;
            return null;
        }
        int length = SMPPIO.readInt4(this.header, 0);
        if (length > this.packet.length) {
            this.packet = new byte[length];
        }
        while (count < length) {
            int n2 = source.read(this.packet, count - 16, length - count);
            if (n2 < 0) {
                return null;
            }
            count += n2;
        }
        int id = SMPPIO.readInt4(this.header, 4);
        SMPPPacket packet = this.packetFactory.newInstance(id);
        this.decoder.reset(count);
        packet.readFrom(this.decoder);
        return packet;
    }

    private class TestDecoder
    extends PacketDecoderImpl {
        int offset;
        int available;

        private TestDecoder() {
        }

        public void reset(int byteCount) {
            this.setBytes(ReplayLink.this.header);
            this.setParsePosition(0);
            this.offset = 0;
            this.available = byteCount;
        }

        public int getAvailableBytes() {
            return this.available;
        }

        public long readUInt4() {
            long val = super.readUInt4();
            if (this.getParsePosition() == 16) {
                this.setBytes(ReplayLink.this.packet);
                this.setParsePosition(0);
                this.offset = 16;
            }
            return val;
        }

        public int getParsePosition() {
            return this.offset + super.getParsePosition();
        }
    }
}

