/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.net;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import org.mobicents.protocols.smpp.message.SMPPPacket;
import org.mobicents.protocols.smpp.net.ReadTimeoutException;
import org.mobicents.protocols.smpp.net.SmscLink;
import org.mobicents.protocols.smpp.util.APIConfig;
import org.mobicents.protocols.smpp.util.APIConfigFactory;
import org.mobicents.protocols.smpp.util.PacketDecoder;
import org.mobicents.protocols.smpp.util.PacketDecoderImpl;
import org.mobicents.protocols.smpp.util.PacketEncoder;
import org.mobicents.protocols.smpp.util.PacketEncoderImpl;
import org.mobicents.protocols.smpp.util.PacketFactory;
import org.mobicents.protocols.smpp.util.PropertyNotFoundException;
import org.mobicents.protocols.smpp.util.SMPPIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStreamLink
implements SmscLink {
    private static final String END_OF_STREAM_ERR = "EOS reached. No data available";
    private static final String LINK_NOT_UP_ERR = "Link not established.";
    private static final Logger LOG = LoggerFactory.getLogger(SmscLink.class);
    private byte[] buffer;
    private InputStream in;
    private OutputStream out;
    private OutputStream snoopIn;
    private OutputStream snoopOut;
    private PacketEncoder encoder;
    private PacketDecoder decoder;
    private PacketEncoder snoopOutEncoder;
    private PacketFactory packetFactory = new PacketFactory();
    private boolean autoFlush;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractStreamLink() {
        try {
            APIConfig config = APIConfigFactory.getConfig();
            this.autoFlush = config.getBoolean("smppapi.net.autoflush");
        }
        catch (PropertyNotFoundException x) {
            this.autoFlush = true;
        }
        finally {
            LOG.debug("autoFlush set to {}", (Object)this.autoFlush);
        }
    }

    public void disconnect() throws IOException {
        this.out = null;
        this.in = null;
        this.buffer = null;
        this.encoder = null;
        this.decoder = null;
        if (this.isAutoCloseSnoop()) {
            this.closeQuietly(this.snoopOut);
            this.closeQuietly(this.snoopIn);
        } else {
            this.flushQuietly(this.snoopOut);
            this.flushQuietly(this.snoopIn);
        }
    }

    public void write(SMPPPacket pak, boolean withOptional) throws IOException {
        if (this.out == null) {
            throw new IOException(LINK_NOT_UP_ERR);
        }
        pak.writeTo(this.encoder, withOptional);
        try {
            if (this.snoopOutEncoder != null) {
                pak.writeTo(this.snoopOutEncoder, withOptional);
            }
        }
        catch (IOException x) {
            LOG.warn("IOException writing to snoop output stream.", (Throwable)x);
        }
        if (this.autoFlush) {
            this.out.flush();
        }
    }

    public void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    public boolean getAutoFlush() {
        return this.autoFlush;
    }

    public void setAutoFlush(boolean flush) {
        this.autoFlush = flush;
    }

    public SMPPPacket read() throws IOException {
        if (this.in == null) {
            throw new IOException(LINK_NOT_UP_ERR);
        }
        int count = 0;
        try {
            count = this.readBytes(this.buffer, 0, 4, 16);
            int cmdLen = SMPPIO.readInt4(this.buffer, 0);
            if (cmdLen > this.buffer.length) {
                byte[] newbuf = new byte[cmdLen];
                System.arraycopy(this.buffer, 0, newbuf, 0, count);
                this.buffer = newbuf;
                this.decoder = new PacketDecoderImpl(this.buffer);
            }
            int remaining = cmdLen - count;
            this.readBytes(this.buffer, count, remaining, remaining);
            int commandId = SMPPIO.readInt4(this.buffer, 4);
            SMPPPacket packet = this.packetFactory.newInstance(commandId);
            this.decoder.setParsePosition(0);
            packet.readFrom(this.decoder);
            SMPPPacket sMPPPacket = packet;
            return sMPPPacket;
        }
        catch (SocketTimeoutException x) {
            throw new ReadTimeoutException(x);
        }
        finally {
            this.dump(this.snoopIn, this.buffer, 0, count);
        }
    }

    public final int available() {
        try {
            return this.in != null ? this.in.available() : 0;
        }
        catch (IOException x) {
            LOG.debug("IOException in available", (Throwable)x);
            return 0;
        }
    }

    public void setSnoopStreams(OutputStream snoopIn, OutputStream snoopOut) {
        this.snoopIn = snoopIn;
        this.snoopOut = snoopOut;
        this.snoopOutEncoder = new PacketEncoderImpl(snoopOut);
    }

    protected void setInputStream(InputStream inputStream) {
        this.in = inputStream;
        this.buffer = new byte[512];
        this.decoder = new PacketDecoderImpl(this.buffer);
    }

    protected void setOutputStream(OutputStream outputStream) {
        this.out = outputStream;
        this.encoder = new PacketEncoderImpl(this.out);
    }

    private int readBytes(byte[] buf, int offset, int minimum, int maxLen) throws IOException {
        int ptr = this.in.read(buf, offset, maxLen);
        if (ptr < minimum) {
            if (ptr == -1) {
                throw new EOFException(END_OF_STREAM_ERR);
            }
            while (ptr < minimum) {
                int count = this.in.read(buf, offset + ptr, maxLen - ptr);
                if (count < 0) {
                    throw new EOFException(END_OF_STREAM_ERR);
                }
                ptr += count;
            }
        }
        return ptr;
    }

    private void dump(OutputStream s, byte[] b, int offset, int len) {
        try {
            if (s != null) {
                s.write(b, offset, len);
            }
        }
        catch (IOException x) {
            LOG.warn("Couldn't write incoming bytes to input snooper.", (Throwable)x);
        }
    }

    private boolean isAutoCloseSnoop() {
        boolean autoClose = true;
        try {
            APIConfig config = APIConfigFactory.getConfig();
            autoClose = config.getBoolean("smppapi.net.autoclose_snoop");
        }
        catch (PropertyNotFoundException x) {
            LOG.debug("{} property not found. Using the default of {}", (Object)"smppapi.net.autoclose_snoop", (Object)autoClose);
        }
        return autoClose;
    }

    private void closeQuietly(OutputStream stream) {
        try {
            stream.close();
        }
        catch (IOException x) {
            LOG.debug("Exception closing a stream quietly", (Throwable)x);
        }
    }

    private void flushQuietly(OutputStream stream) {
        try {
            stream.flush();
        }
        catch (IOException x) {
            LOG.debug("Exception flushing a stream quietly", (Throwable)x);
        }
    }
}

