/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.message.tlv;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.mobicents.protocols.smpp.message.param.ParamDescriptor;
import org.mobicents.protocols.smpp.message.tlv.BasicDescriptors;
import org.mobicents.protocols.smpp.message.tlv.TagDefinedException;

public final class Tag
implements Serializable {
    private static Map<Integer, Tag> tagTable = new HashMap<Integer, Tag>();
    static final long serialVersionUID = 2L;
    public static final Tag DEST_ADDR_SUBUNIT = new Tag(5, BasicDescriptors.INTEGER1, 1);
    public static final Tag DEST_NETWORK_TYPE = new Tag(6, BasicDescriptors.INTEGER1, 1);
    public static final Tag DEST_BEARER_TYPE = new Tag(7, BasicDescriptors.INTEGER1, 1);
    public static final Tag DEST_TELEMATICS_ID = new Tag(8, BasicDescriptors.INTEGER2, 2);
    public static final Tag SOURCE_ADDR_SUBUNIT = new Tag(13, BasicDescriptors.INTEGER1, 1);
    public static final Tag SOURCE_NETWORK_TYPE = new Tag(14, BasicDescriptors.INTEGER1, 1);
    public static final Tag SOURCE_BEARER_TYPE = new Tag(15, BasicDescriptors.INTEGER1, 1);
    public static final Tag SOURCE_TELEMATICS_ID = new Tag(16, BasicDescriptors.INTEGER1, 1);
    public static final Tag QOS_TIME_TO_LIVE = new Tag(23, BasicDescriptors.INTEGER4, 4);
    public static final Tag PAYLOAD_TYPE = new Tag(25, BasicDescriptors.INTEGER1, 1);
    public static final Tag ADDITIONAL_STATUS_INFO_TEXT = new Tag(29, BasicDescriptors.CSTRING, 1, 256);
    public static final Tag RECEIPTED_MESSAGE_ID = new Tag(30, BasicDescriptors.CSTRING, 1, 65);
    public static final Tag MS_MSG_WAIT_FACILITIES = new Tag(48, BasicDescriptors.BITMASK, 1);
    public static final Tag PRIVACY_INDICATOR = new Tag(513, BasicDescriptors.INTEGER1, 1);
    public static final Tag SOURCE_SUBADDRESS = new Tag(514, BasicDescriptors.BYTES, 2, 23);
    public static final Tag DEST_SUBADDRESS = new Tag(515, BasicDescriptors.BYTES, 2, 23);
    public static final Tag USER_MESSAGE_REFERENCE = new Tag(516, BasicDescriptors.INTEGER2, 2);
    public static final Tag USER_RESPONSE_CODE = new Tag(517, BasicDescriptors.INTEGER1, 1);
    public static final Tag SOURCE_PORT = new Tag(522, BasicDescriptors.INTEGER2, 2);
    public static final Tag DESTINATION_PORT = new Tag(523, BasicDescriptors.INTEGER2, 2);
    public static final Tag SAR_MSG_REF_NUM = new Tag(524, BasicDescriptors.INTEGER2, 2);
    public static final Tag LANGUAGE_INDICATOR = new Tag(525, BasicDescriptors.INTEGER1, 1);
    public static final Tag SAR_TOTAL_SEGMENTS = new Tag(526, BasicDescriptors.INTEGER1, 1);
    public static final Tag SAR_SEGMENT_SEQNUM = new Tag(527, BasicDescriptors.INTEGER1, 1);
    public static final Tag SC_INTERFACE_VERSION = new Tag(528, BasicDescriptors.INTEGER1, 1);
    public static final Tag CALLBACK_NUM_PRES_IND = new Tag(770, BasicDescriptors.BITMASK, 1);
    public static final Tag CALLBACK_NUM_ATAG = new Tag(771, BasicDescriptors.BYTES, 0, 65);
    public static final Tag NUMBER_OF_MESSAGES = new Tag(772, BasicDescriptors.INTEGER1, 1);
    public static final Tag CALLBACK_NUM = new Tag(897, BasicDescriptors.BYTES, 4, 19);
    public static final Tag DPF_RESULT = new Tag(1056, BasicDescriptors.INTEGER1, 1);
    public static final Tag SET_DPF = new Tag(1057, BasicDescriptors.INTEGER1, 1);
    public static final Tag MS_AVAILABILITY_STATUS = new Tag(1058, BasicDescriptors.INTEGER1, 1);
    public static final Tag NETWORK_ERROR_CODE = new Tag(1059, BasicDescriptors.BYTES, 3);
    public static final Tag MESSAGE_PAYLOAD = new Tag(1060, BasicDescriptors.BYTES, -1);
    public static final Tag DELIVERY_FAILURE_REASON = new Tag(1061, BasicDescriptors.INTEGER1, 1);
    public static final Tag MORE_MESSAGES_TO_SEND = new Tag(1062, BasicDescriptors.INTEGER1, 1);
    public static final Tag MESSAGE_STATE = new Tag(1063, BasicDescriptors.INTEGER1, 1);
    public static final Tag USSD_SERVICE_OP = new Tag(1281, BasicDescriptors.BYTES, 1);
    public static final Tag DISPLAY_TIME = new Tag(4609, BasicDescriptors.INTEGER1, 1);
    public static final Tag SMS_SIGNAL = new Tag(4611, BasicDescriptors.INTEGER2, 2);
    public static final Tag MS_VALIDITY = new Tag(4612, BasicDescriptors.INTEGER1, 1);
    public static final Tag ALERT_ON_MESSAGE_DELIVERY = new Tag(4876, null, 0);
    public static final Tag ITS_REPLY_TYPE = new Tag(4992, BasicDescriptors.INTEGER1, 1);
    public static final Tag ITS_SESSION_INFO = new Tag(4995, BasicDescriptors.BYTES, 2);
    public static final Tag BROADCAST_AREA_IDENTIFIER = new Tag(1542, BasicDescriptors.BYTES, -1);
    public static final Tag BROADCAST_AREA_SUCCESS = new Tag(1544, BasicDescriptors.INTEGER1, 1);
    public static final Tag BROADCAST_CONTENT_TYPE_INFO = new Tag(1538, BasicDescriptors.BYTES, 1, 255);
    public static final Tag BROADCAST_CHANNEL_INDICATOR = new Tag(1536, BasicDescriptors.INTEGER1, 1);
    public static final Tag BROADCAST_CONTENT_TYPE = new Tag(1537, BasicDescriptors.BYTES, 1, 255);
    public static final Tag BROADCAST_END_TIME = new Tag(1545, BasicDescriptors.DATE, 16, 16);
    public static final Tag BROADCAST_ERROR_STATUS = new Tag(1543, BasicDescriptors.INTEGER4, 4);
    public static final Tag BROADCAST_FREQUENCY_INTERVAL = new Tag(1541, BasicDescriptors.BYTES, 3);
    public static final Tag BROADCAST_MESSAGE_CLASS = new Tag(1539, BasicDescriptors.INTEGER1, 1);
    public static final Tag BROADCAST_REP_NUM = new Tag(1540, BasicDescriptors.INTEGER2, 2);
    public static final Tag BROADCAST_SERVICE_GROUP = new Tag(1546, BasicDescriptors.BYTES, 1, 255);
    private Integer tag;
    private int minLength = -1;
    private int maxLength = -1;
    private ParamDescriptor paramDescriptor;

    private Tag(int tag, ParamDescriptor paramDescriptor, int fixedLength) throws TagDefinedException {
        this(tag, paramDescriptor, fixedLength, fixedLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tag(int tag, ParamDescriptor paramDescriptor, int minLength, int maxLength) throws TagDefinedException {
        this.tag = new Integer(tag);
        this.paramDescriptor = paramDescriptor;
        this.minLength = minLength;
        this.maxLength = maxLength;
        Map<Integer, Tag> map = tagTable;
        synchronized (map) {
            if (tagTable.containsKey(this.tag)) {
                throw new TagDefinedException(tag, "Tag 0x" + Integer.toHexString(tag) + " is already defined.");
            }
            tagTable.put(this.tag, this);
        }
    }

    public int intValue() {
        return this.tag;
    }

    public int getLength() {
        return this.maxLength < 0 ? this.minLength : this.maxLength;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public ParamDescriptor getParamDescriptor() {
        return this.paramDescriptor;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Tag)) {
            return false;
        }
        if (this.tag == null) {
            return false;
        }
        Tag other = (Tag)obj;
        if (other.tag == null) {
            return false;
        }
        return this.tag.intValue() == other.tag.intValue();
    }

    public boolean equals(int tag) {
        return tag == this.tag;
    }

    public int hashCode() {
        return this.tag.hashCode();
    }

    public String toString() {
        return this.tag.toString();
    }

    public String toHexString() {
        return Integer.toHexString(this.tag);
    }

    public static Tag getTag(int tagValue) {
        Tag t = tagTable.get(new Integer(tagValue));
        if (t == null) {
            return Tag.defineTag(tagValue, BasicDescriptors.BYTES, -1);
        }
        return t;
    }

    public static Tag defineTag(int tagValue, ParamDescriptor paramDescriptor, int fixedSize) throws TagDefinedException {
        return new Tag(tagValue, paramDescriptor, fixedSize, fixedSize);
    }

    public static Tag defineTag(int tagValue, ParamDescriptor paramDescriptor, int minSize, int maxSize) throws TagDefinedException {
        return new Tag(tagValue, paramDescriptor, minSize, maxSize);
    }

    public static boolean isTagDefined(int tagValue) {
        return tagTable.containsKey(new Integer(tagValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tag undefineTag(Tag tag) {
        if (tag == null) {
            return null;
        }
        Map<Integer, Tag> map = tagTable;
        synchronized (map) {
            return tagTable.remove(tag.tag);
        }
    }
}

