/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.message.tlv;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.mobicents.protocols.smpp.message.param.ParamDescriptor;
import org.mobicents.protocols.smpp.message.tlv.BadValueTypeException;
import org.mobicents.protocols.smpp.message.tlv.BasicDescriptors;
import org.mobicents.protocols.smpp.message.tlv.InvalidSizeForValueException;
import org.mobicents.protocols.smpp.message.tlv.TLVTable;
import org.mobicents.protocols.smpp.message.tlv.Tag;
import org.mobicents.protocols.smpp.util.PacketDecoder;
import org.mobicents.protocols.smpp.util.PacketEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TLVTableImpl
extends LinkedHashMap<Tag, Object>
implements TLVTable {
    private static final long serialVersionUID = 2L;

    @Override
    public void readFrom(PacketDecoder decoder, int length) {
        int endIndex = decoder.getParsePosition() + length - 1;
        while (decoder.getParsePosition() < endIndex) {
            Object val = null;
            Tag tag = Tag.getTag(decoder.readUInt2());
            int valueLen = decoder.readUInt2();
            ParamDescriptor descriptor = tag.getParamDescriptor();
            val = descriptor.readObject(decoder, valueLen);
            this.put(tag, val);
        }
    }

    @Override
    public void writeTo(PacketEncoder encoder) throws IOException {
        for (Map.Entry entry : this.entrySet()) {
            Tag tag = (Tag)entry.getKey();
            Object value = entry.getValue();
            ParamDescriptor descriptor = tag.getParamDescriptor();
            int valueLen = descriptor.sizeOf(value);
            encoder.writeUInt2(tag.intValue());
            encoder.writeUInt2(valueLen);
            descriptor.writeObject(value, encoder);
        }
    }

    @Override
    public Object get(int tag) {
        Tag tagObj = Tag.getTag(tag);
        return this.get(tagObj);
    }

    @Override
    public String getString(Tag tag) {
        Object obj = this.get(tag);
        return obj != null ? obj.toString() : null;
    }

    @Override
    public int getInt(Tag tag) {
        Object obj = this.get(tag);
        if (obj != null) {
            return ((Number)obj).intValue();
        }
        return -1;
    }

    @Override
    public long getLong(Tag tag) {
        Object obj = this.get(tag);
        if (obj != null) {
            return ((Number)obj).intValue();
        }
        return -1L;
    }

    @Override
    public BitSet getBitmask(Tag tag) {
        return (BitSet)this.get(tag);
    }

    @Override
    public byte[] getBytes(Tag tag) {
        return (byte[])this.get(tag);
    }

    @Override
    public Object put(Tag tag, Object value) throws BadValueTypeException, InvalidSizeForValueException {
        ParamDescriptor descriptor = tag.getParamDescriptor();
        if (descriptor.equals(BasicDescriptors.NULL) && value != null) {
            String error = MessageFormat.format("Tag {0} does not accept any value.", tag);
            throw new BadValueTypeException(error);
        }
        if (value == null) {
            String error = MessageFormat.format("Tag {0} does not accept a null value.", tag);
            throw new BadValueTypeException(error);
        }
        int min = tag.getMinLength();
        int max = tag.getMaxLength();
        int actual = descriptor.sizeOf(value);
        if (min > -1 && actual < min || max > -1 && actual > max) {
            throw new InvalidSizeForValueException("Tag " + tag.toHexString() + " must have a length in the range " + min + " <= len <= " + max);
        }
        return super.put(tag, value);
    }

    @Override
    public Object put(Tag tag, char value) {
        return this.put(tag, (Object)Character.valueOf(value));
    }

    @Override
    public Object put(Tag tag, short value) {
        return this.put(tag, (Object)value);
    }

    @Override
    public Object put(Tag tag, int value) {
        return this.put(tag, (Object)value);
    }

    @Override
    public Object put(Tag tag, long value) {
        return this.put(tag, (Object)value);
    }

    @Override
    public void remove(int tag) {
        super.remove(Tag.getTag(tag));
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (Map.Entry entry : this.entrySet()) {
            ParamDescriptor descriptor = ((Tag)entry.getKey()).getParamDescriptor();
            Object value = entry.getValue();
            buffer.append('{').append(((Tag)entry.getKey()).toHexString()).append(',').append(descriptor.sizeOf(value)).append(',').append(value);
        }
        return buffer.toString();
    }

    @Override
    public int getLength() {
        int length = this.size() * 4;
        for (Map.Entry entry : this.entrySet()) {
            Tag tag = (Tag)entry.getKey();
            length += tag.getParamDescriptor().sizeOf(entry.getValue());
        }
        return length;
    }
}

