/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.message.param;

import java.io.IOException;
import org.mobicents.protocols.smpp.message.param.AbstractDescriptor;
import org.mobicents.protocols.smpp.util.PacketDecoder;
import org.mobicents.protocols.smpp.util.PacketEncoder;

public class IntegerParamDescriptor
extends AbstractDescriptor {
    private static final long serialVersionUID = 2L;
    private int length;

    public IntegerParamDescriptor(int length) {
        this.length = length;
    }

    public int getLengthSpecifier() {
        return -1;
    }

    public int sizeOf(Object obj) {
        return this.length;
    }

    public void writeObject(Object obj, PacketEncoder encoder) throws IOException {
        if (!(obj instanceof Number)) {
            throw new IllegalArgumentException("Invalid object type.");
        }
        long value = ((Number)obj).longValue();
        switch (this.length) {
            case 8: {
                encoder.writeInt8(value);
                break;
            }
            case 4: {
                encoder.writeUInt4(value);
                break;
            }
            case 2: {
                encoder.writeUInt2((int)value);
                break;
            }
            default: {
                encoder.writeUInt1((int)value);
            }
        }
    }

    public Object readObject(PacketDecoder decoder, int length) {
        Number value;
        switch (this.length) {
            case 8: {
                value = new Long(decoder.readInt8());
                break;
            }
            case 4: {
                value = new Long(decoder.readUInt4());
                break;
            }
            case 2: {
                value = new Integer(decoder.readUInt2());
                break;
            }
            default: {
                value = new Integer(decoder.readUInt1());
            }
        }
        return value;
    }
}

