/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.message.param;

import java.io.IOException;
import java.util.BitSet;
import org.mobicents.protocols.smpp.message.param.AbstractDescriptor;
import org.mobicents.protocols.smpp.util.PacketDecoder;
import org.mobicents.protocols.smpp.util.PacketEncoder;

public class BitmaskParamDescriptor
extends AbstractDescriptor {
    private static final long serialVersionUID = 2L;

    public int getLengthSpecifier() {
        return -1;
    }

    public int sizeOf(Object obj) {
        return 1;
    }

    public void writeObject(Object obj, PacketEncoder encoder) throws IOException {
        encoder.writeUInt1(this.bitsetToInt((BitSet)obj));
    }

    public Object readObject(PacketDecoder decoder, int length) {
        int bits = decoder.readUInt1();
        BitSet bitset = new BitSet();
        for (int i = 0; i < 8; ++i) {
            if ((bits & 1 << i) == 0) continue;
            bitset.set(i);
        }
        return bitset;
    }

    private int bitsetToInt(BitSet bitSet) {
        int value = 0;
        int i = bitSet.nextSetBit(0);
        while (i >= 0 && i < 8) {
            int bit = i % 8;
            value |= 1 << bit;
            i = bitSet.nextSetBit(i + 1);
        }
        return value;
    }
}

