/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.message;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.mobicents.protocols.smpp.Address;
import org.mobicents.protocols.smpp.message.SMPPPacket;
import org.mobicents.protocols.smpp.util.PacketDecoder;
import org.mobicents.protocols.smpp.util.PacketEncoder;
import org.mobicents.protocols.smpp.util.SMPPDate;

public class SubmitSM
extends SMPPPacket {
    private static final long serialVersionUID = 2L;
    private String serviceType;
    private Address source;
    private Address destination;
    private int esmClass;
    private int protocolID;
    private int priority;
    private SMPPDate deliveryTime;
    private SMPPDate expiryTime;
    private int registered;
    private int replaceIfPresent;
    private int dataCoding;
    private int defaultMsg;
    private byte[] message;

    public SubmitSM() {
        super(4);
    }

    SubmitSM(int commandId) {
        super(commandId);
    }

    public int getDataCoding() {
        return this.dataCoding;
    }

    public void setDataCoding(int dataCoding) {
        this.dataCoding = dataCoding;
    }

    public int getDefaultMsg() {
        return this.defaultMsg;
    }

    public void setDefaultMsg(int defaultMsg) {
        this.defaultMsg = defaultMsg;
    }

    public SMPPDate getDeliveryTime() {
        return this.deliveryTime;
    }

    public void setDeliveryTime(SMPPDate deliveryTime) {
        this.deliveryTime = deliveryTime;
    }

    public Address getDestination() {
        return this.destination;
    }

    public void setDestination(Address destination) {
        this.destination = destination;
    }

    public int getEsmClass() {
        return this.esmClass;
    }

    public void setEsmClass(int esmClass) {
        this.esmClass = esmClass;
    }

    public SMPPDate getExpiryTime() {
        return this.expiryTime;
    }

    public void setExpiryTime(SMPPDate expiryTime) {
        this.expiryTime = expiryTime;
    }

    public byte[] getMessage() {
        return this.message;
    }

    public void setMessage(byte[] message) {
        this.message = message;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getProtocolID() {
        return this.protocolID;
    }

    public void setProtocolID(int protocolID) {
        this.protocolID = protocolID;
    }

    public int getRegistered() {
        return this.registered;
    }

    public void setRegistered(int registered) {
        this.registered = registered;
    }

    public int getReplaceIfPresent() {
        return this.replaceIfPresent;
    }

    public void setReplaceIfPresent(int replaceIfPresent) {
        this.replaceIfPresent = replaceIfPresent;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public Address getSource() {
        return this.source;
    }

    public void setSource(Address source) {
        this.source = source;
    }

    public boolean equals(Object obj) {
        boolean equals = super.equals(obj);
        if (equals) {
            SubmitSM other = (SubmitSM)obj;
            equals |= this.safeCompare(this.serviceType, other.serviceType);
            equals |= this.safeCompare(this.source, other.source);
            equals |= this.safeCompare(this.destination, other.destination);
            equals |= this.esmClass == other.esmClass;
            equals |= this.protocolID == other.protocolID;
            equals |= this.priority == other.priority;
            equals |= this.safeCompare(this.deliveryTime, other.deliveryTime);
            equals |= this.safeCompare(this.expiryTime, other.expiryTime);
            equals |= this.registered == other.registered;
            equals |= this.replaceIfPresent == other.replaceIfPresent;
            equals |= this.dataCoding == other.dataCoding;
            equals |= this.defaultMsg == other.defaultMsg;
            equals |= Arrays.equals(this.message, other.message);
        }
        return equals;
    }

    public int hashCode() {
        int hc = super.hashCode();
        hc += this.serviceType != null ? this.serviceType.hashCode() : 0;
        hc += this.source != null ? this.source.hashCode() : 0;
        hc += this.destination != null ? this.destination.hashCode() : 0;
        hc += Integer.valueOf(this.esmClass).hashCode();
        hc += Integer.valueOf(this.protocolID).hashCode();
        hc += Integer.valueOf(this.priority).hashCode();
        hc += this.deliveryTime != null ? this.deliveryTime.hashCode() : 0;
        hc += this.expiryTime != null ? this.expiryTime.hashCode() : 0;
        hc += Integer.valueOf(this.registered).hashCode();
        hc += Integer.valueOf(this.replaceIfPresent).hashCode();
        hc += Integer.valueOf(this.dataCoding).hashCode();
        hc += Integer.valueOf(this.defaultMsg).hashCode();
        if (this.message != null) {
            try {
                hc += new String(this.message, "US-ASCII").hashCode();
            }
            catch (UnsupportedEncodingException x) {
                throw new RuntimeException(x);
            }
        }
        return hc;
    }

    public int getMandatorySize() {
        int len = (this.serviceType != null ? this.serviceType.length() : 0) + (this.source != null ? this.source.getLength() : 3) + (this.destination != null ? this.destination.getLength() : 3) + (this.deliveryTime != null ? this.deliveryTime.getLength() : 1) + (this.expiryTime != null ? this.expiryTime.getLength() : 1) + (this.message != null ? this.message.length + 1 : 1);
        return len + 8;
    }

    protected void writeMandatory(PacketEncoder encoder) throws IOException {
        encoder.writeCString(this.serviceType);
        if (this.source != null) {
            this.source.writeTo(encoder);
        } else {
            new Address().writeTo(encoder);
        }
        if (this.destination != null) {
            this.destination.writeTo(encoder);
        } else {
            new Address().writeTo(encoder);
        }
        encoder.writeUInt1(this.esmClass);
        encoder.writeUInt1(this.protocolID);
        encoder.writeUInt1(this.priority);
        encoder.writeDate(this.deliveryTime);
        encoder.writeDate(this.expiryTime);
        encoder.writeUInt1(this.registered);
        encoder.writeUInt1(this.replaceIfPresent);
        encoder.writeUInt1(this.dataCoding);
        encoder.writeUInt1(this.defaultMsg);
        int smLength = 0;
        if (this.message != null) {
            smLength = this.message.length;
        }
        encoder.writeUInt1(smLength);
        if (this.message != null) {
            encoder.writeBytes(this.message);
        }
    }

    protected void readMandatory(PacketDecoder decoder) {
        this.serviceType = decoder.readCString();
        this.source = new Address();
        this.source.readFrom(decoder);
        this.destination = new Address();
        this.destination.readFrom(decoder);
        this.esmClass = decoder.readUInt1();
        this.protocolID = decoder.readUInt1();
        this.priority = decoder.readUInt1();
        this.deliveryTime = decoder.readDate();
        this.expiryTime = decoder.readDate();
        this.registered = decoder.readUInt1();
        this.replaceIfPresent = decoder.readUInt1();
        this.dataCoding = decoder.readUInt1();
        this.defaultMsg = decoder.readUInt1();
        int smLength = decoder.readUInt1();
        if (smLength > 0) {
            this.message = decoder.readBytes(smLength);
        }
    }
}

