/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.message;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.mobicents.protocols.smpp.Address;
import org.mobicents.protocols.smpp.ErrorAddress;
import org.mobicents.protocols.smpp.message.SMPPPacket;
import org.mobicents.protocols.smpp.util.PacketDecoder;
import org.mobicents.protocols.smpp.util.PacketEncoder;
import org.mobicents.protocols.smpp.version.SMPPVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubmitMultiResp
extends SMPPPacket {
    private static final long serialVersionUID = 2L;
    private String messageId;
    private List<ErrorAddress> unsuccessfulTable = new ArrayList<ErrorAddress>();

    public SubmitMultiResp() {
        super(-2147483615);
    }

    public SubmitMultiResp(SMPPPacket request) {
        super(request);
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public int getUnsuccessfulCount() {
        return this.unsuccessfulTable.size();
    }

    public int add(ErrorAddress ea) {
        this.unsuccessfulTable.add(ea);
        return this.unsuccessfulTable.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int remove(Address a) {
        List<ErrorAddress> list = this.unsuccessfulTable;
        synchronized (list) {
            int i = this.unsuccessfulTable.indexOf(a);
            if (i > -1) {
                this.unsuccessfulTable.remove(i);
            }
            return this.unsuccessfulTable.size();
        }
    }

    public ListIterator<ErrorAddress> tableIterator() {
        return this.unsuccessfulTable.listIterator();
    }

    @Override
    public boolean equals(Object obj) {
        boolean equals = super.equals(obj);
        if (equals) {
            SubmitMultiResp other = (SubmitMultiResp)obj;
            equals |= this.safeCompare(this.messageId, other.messageId);
            equals |= this.safeCompare(this.unsuccessfulTable, other.unsuccessfulTable);
        }
        return equals;
    }

    @Override
    public int hashCode() {
        int hc = super.hashCode();
        hc += this.messageId != null ? this.messageId.hashCode() : 0;
        return hc += this.unsuccessfulTable != null ? ((Object)this.unsuccessfulTable).hashCode() : 0;
    }

    @Override
    protected void toString(StringBuilder buffer) {
        buffer.append("messageId=").append(this.messageId).append(",unsuccessfulCount=").append(this.unsuccessfulTable.size()).append(",unsuccessful=").append(this.unsuccessfulTable);
    }

    @Override
    protected void validateMandatory(SMPPVersion smppVersion) {
        smppVersion.validateMessageId(this.messageId);
        smppVersion.validateNumUnsuccessful(this.unsuccessfulTable.size());
    }

    @Override
    protected void readMandatory(PacketDecoder decoder) {
        this.messageId = decoder.readCString();
        int count = decoder.readUInt1();
        this.unsuccessfulTable = new ArrayList<ErrorAddress>();
        for (int i = 0; i < count; ++i) {
            this.unsuccessfulTable.add(decoder.readErrorAddress());
        }
    }

    @Override
    protected void writeMandatory(PacketEncoder encoder) throws IOException {
        encoder.writeCString(this.messageId);
        encoder.writeUInt1(this.unsuccessfulTable.size());
        for (ErrorAddress errorAddress : this.unsuccessfulTable) {
            encoder.writeErrorAddress(errorAddress);
        }
    }

    @Override
    protected int getMandatorySize() {
        int length = 2;
        length += this.sizeOf(this.messageId);
        for (ErrorAddress ea : this.unsuccessfulTable) {
            length += ea.getLength();
        }
        return length;
    }
}

