/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.message;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.mobicents.protocols.smpp.Address;
import org.mobicents.protocols.smpp.message.DestinationTable;
import org.mobicents.protocols.smpp.message.SMPPPacket;
import org.mobicents.protocols.smpp.util.PacketDecoder;
import org.mobicents.protocols.smpp.util.PacketEncoder;
import org.mobicents.protocols.smpp.util.SMPPDate;
import org.mobicents.protocols.smpp.version.SMPPVersion;

public class SubmitMulti
extends SMPPPacket {
    private static final long serialVersionUID = 2L;
    private String serviceType;
    private Address source;
    private DestinationTable destinationTable = new DestinationTable();
    private int esmClass;
    private int protocolID;
    private int priority;
    private SMPPDate deliveryTime;
    private SMPPDate expiryTime;
    private int registered;
    private int replaceIfPresent;
    private int dataCoding;
    private int defaultMsg;
    private byte[] message;

    public SubmitMulti() {
        super(33);
    }

    public DestinationTable getDestinationTable() {
        return this.destinationTable;
    }

    public int getDataCoding() {
        return this.dataCoding;
    }

    public void setDataCoding(int dataCoding) {
        this.dataCoding = dataCoding;
    }

    public int getDefaultMsg() {
        return this.defaultMsg;
    }

    public void setDefaultMsg(int defaultMsg) {
        this.defaultMsg = defaultMsg;
    }

    public SMPPDate getDeliveryTime() {
        return this.deliveryTime;
    }

    public void setDeliveryTime(SMPPDate deliveryTime) {
        this.deliveryTime = deliveryTime;
    }

    public int getEsmClass() {
        return this.esmClass;
    }

    public void setEsmClass(int esmClass) {
        this.esmClass = esmClass;
    }

    public SMPPDate getExpiryTime() {
        return this.expiryTime;
    }

    public void setExpiryTime(SMPPDate expiryTime) {
        this.expiryTime = expiryTime;
    }

    public byte[] getMessage() {
        return this.message;
    }

    public void setMessage(byte[] message) {
        this.message = message;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getProtocolID() {
        return this.protocolID;
    }

    public void setProtocolID(int protocolID) {
        this.protocolID = protocolID;
    }

    public int getRegistered() {
        return this.registered;
    }

    public void setRegistered(int registered) {
        this.registered = registered;
    }

    public int getReplaceIfPresent() {
        return this.replaceIfPresent;
    }

    public void setReplaceIfPresent(int replaceIfPresent) {
        this.replaceIfPresent = replaceIfPresent;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public Address getSource() {
        return this.source;
    }

    public void setSource(Address source) {
        this.source = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addDestination(Address d) {
        DestinationTable destinationTable = this.destinationTable;
        synchronized (destinationTable) {
            this.destinationTable.add(d);
            return this.destinationTable.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addDestination(String d) {
        DestinationTable destinationTable = this.destinationTable;
        synchronized (destinationTable) {
            this.destinationTable.add(d);
            return this.destinationTable.size();
        }
    }

    public int getNumDests() {
        return this.destinationTable.size();
    }

    public boolean equals(Object obj) {
        boolean equals = super.equals(obj);
        if (equals) {
            SubmitMulti other = (SubmitMulti)obj;
            equals |= this.safeCompare(this.serviceType, other.serviceType);
            equals |= this.safeCompare(this.source, other.source);
            equals |= this.safeCompare(this.destinationTable, other.destinationTable);
            equals |= this.esmClass == other.esmClass;
            equals |= this.protocolID == other.protocolID;
            equals |= this.priority == other.priority;
            equals |= this.safeCompare(this.deliveryTime, other.deliveryTime);
            equals |= this.safeCompare(this.expiryTime, other.expiryTime);
            equals |= this.registered == other.registered;
            equals |= this.replaceIfPresent == other.replaceIfPresent;
            equals |= this.dataCoding == other.dataCoding;
            equals |= this.defaultMsg == other.defaultMsg;
            equals |= Arrays.equals(this.message, other.message);
        }
        return equals;
    }

    public int hashCode() {
        int hc = super.hashCode();
        hc += this.serviceType != null ? this.serviceType.hashCode() : 0;
        hc += this.source != null ? this.source.hashCode() : 0;
        hc += this.destinationTable != null ? this.destinationTable.hashCode() : 0;
        hc += Integer.valueOf(this.esmClass).hashCode();
        hc += Integer.valueOf(this.protocolID).hashCode();
        hc += Integer.valueOf(this.priority).hashCode();
        hc += this.deliveryTime != null ? this.deliveryTime.hashCode() : 0;
        hc += this.expiryTime != null ? this.expiryTime.hashCode() : 0;
        hc += Integer.valueOf(this.registered).hashCode();
        hc += Integer.valueOf(this.replaceIfPresent).hashCode();
        hc += Integer.valueOf(this.dataCoding).hashCode();
        hc += Integer.valueOf(this.defaultMsg).hashCode();
        if (this.message != null) {
            try {
                hc += new String(this.message, "US-ASCII").hashCode();
            }
            catch (UnsupportedEncodingException x) {
                throw new RuntimeException(x);
            }
        }
        return hc;
    }

    protected void toString(StringBuilder buffer) {
        int length = 0;
        if (this.message != null) {
            length = this.message.length;
        }
        buffer.append("serviceType=").append(this.serviceType).append(",source=").append(this.source).append(",numberOfDests=").append(this.destinationTable.size()).append(",destinations=").append(this.destinationTable).append(",esmClass=").append(this.esmClass).append(",protocolID=").append(this.protocolID).append(",priority=").append(this.priority).append(",deliveryTime=").append(this.deliveryTime).append(",expiryTime=").append(this.expiryTime).append(",registered=").append(this.registered).append(",replaceIfPresent=").append(this.replaceIfPresent).append(",dataCoding=").append(this.dataCoding).append(",defaultMsg=").append(this.defaultMsg).append(",smLength=").append(length).append(",message=").append(this.message);
    }

    protected void validateMandatory(SMPPVersion smppVersion) {
        super.validateMandatory(smppVersion);
        smppVersion.validateNumberOfDests(this.destinationTable.size());
        for (Address address : this.destinationTable.getAddresses()) {
            smppVersion.validateAddress(address);
        }
        for (String distributionList : this.destinationTable.getDistributionLists()) {
            smppVersion.validateDistListName(distributionList);
        }
    }

    protected void readMandatory(PacketDecoder decoder) {
        this.serviceType = decoder.readCString();
        this.source = decoder.readAddress();
        int numDests = decoder.readUInt1();
        this.destinationTable = new DestinationTable();
        this.destinationTable.readFrom(decoder, numDests);
        this.esmClass = decoder.readUInt1();
        this.protocolID = decoder.readUInt1();
        this.priority = decoder.readUInt1();
        this.deliveryTime = decoder.readDate();
        this.expiryTime = decoder.readDate();
        this.registered = decoder.readUInt1();
        this.replaceIfPresent = decoder.readUInt1();
        this.dataCoding = decoder.readUInt1();
        this.defaultMsg = decoder.readUInt1();
        int len = decoder.readUInt1();
        this.message = decoder.readBytes(len);
    }

    protected void writeMandatory(PacketEncoder encoder) throws IOException {
        encoder.writeCString(this.serviceType);
        encoder.writeAddress(this.source);
        int numDests = this.destinationTable.size();
        encoder.writeUInt1(numDests);
        this.destinationTable.writeTo(encoder);
        encoder.writeUInt1(this.esmClass);
        encoder.writeUInt1(this.protocolID);
        encoder.writeUInt1(this.priority);
        encoder.writeDate(this.deliveryTime);
        encoder.writeDate(this.expiryTime);
        encoder.writeUInt1(this.registered);
        encoder.writeUInt1(this.replaceIfPresent);
        encoder.writeUInt1(this.dataCoding);
        encoder.writeUInt1(this.defaultMsg);
        int len = this.message != null ? this.message.length : 0;
        encoder.writeUInt1(len);
        encoder.writeBytes(this.message, 0, len);
    }

    protected int getMandatorySize() {
        int l = 10;
        l += this.sizeOf(this.serviceType);
        l += this.sizeOf(this.source);
        l += this.destinationTable.getLength();
        l += this.sizeOf(this.deliveryTime);
        l += this.sizeOf(this.expiryTime);
        return l += this.sizeOf(this.message);
    }
}

