/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.message;

import java.io.IOException;
import java.io.Serializable;
import org.mobicents.protocols.smpp.Address;
import org.mobicents.protocols.smpp.SMPPRuntimeException;
import org.mobicents.protocols.smpp.message.SMPPProtocolException;
import org.mobicents.protocols.smpp.message.tlv.TLVTable;
import org.mobicents.protocols.smpp.message.tlv.TLVTableImpl;
import org.mobicents.protocols.smpp.message.tlv.Tag;
import org.mobicents.protocols.smpp.util.PacketDecoder;
import org.mobicents.protocols.smpp.util.PacketEncoder;
import org.mobicents.protocols.smpp.util.SMPPDate;
import org.mobicents.protocols.smpp.version.SMPPVersion;
import org.mobicents.protocols.smpp.version.VersionException;

public abstract class SMPPPacket
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2L;
    protected int commandId;
    protected int commandStatus;
    protected long sequenceNum = -1L;
    protected TLVTable tlvTable = new TLVTableImpl();

    protected SMPPPacket(int commandId) {
        this.commandId = commandId;
    }

    protected SMPPPacket(SMPPPacket request) {
        this.commandId = request.commandId | Integer.MIN_VALUE;
        this.sequenceNum = request.sequenceNum;
    }

    public boolean isRequest() {
        return !this.isResponse();
    }

    public boolean isResponse() {
        return (this.commandId & Integer.MIN_VALUE) != 0;
    }

    public int getCommandId() {
        return this.commandId;
    }

    public int getCommandStatus() {
        return this.commandStatus;
    }

    public void setCommandStatus(int commandStatus) {
        this.commandStatus = commandStatus;
    }

    public long getSequenceNum() {
        return this.sequenceNum;
    }

    public void setSequenceNum(long sequenceNum) {
        this.sequenceNum = sequenceNum;
    }

    public TLVTable getTLVTable() {
        return this.tlvTable;
    }

    public Object setTLV(Tag tag, Object value) {
        return this.tlvTable.put(tag, value);
    }

    public Object getTLV(Tag tag) {
        return this.tlvTable.get(tag);
    }

    public Object removeTLV(Tag tag) {
        return this.tlvTable.remove(tag);
    }

    public boolean isSet(Tag tag) {
        return this.tlvTable.containsKey(tag);
    }

    public final int getLength() {
        return 16 + this.getMandatorySize() + this.tlvTable.getLength();
    }

    public void writeTo(PacketEncoder encoder) throws IOException {
        this.writeTo(encoder, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeTo(PacketEncoder encoder, boolean withOptional) throws IOException {
        int commandLen = 16 + this.getMandatorySize();
        if (withOptional) {
            commandLen += this.tlvTable.getLength();
        }
        PacketEncoder packetEncoder = encoder;
        synchronized (packetEncoder) {
            encoder.writeInt4(commandLen);
            encoder.writeInt4(this.commandId);
            encoder.writeInt4(this.commandStatus);
            encoder.writeUInt4(this.sequenceNum);
            this.writeMandatory(encoder);
            if (withOptional) {
                this.tlvTable.writeTo(encoder);
            }
        }
    }

    public void readFrom(PacketDecoder decoder) throws SMPPProtocolException {
        this.tlvTable.clear();
        int startPos = decoder.getParsePosition();
        int commandLen = this.readHeader(decoder);
        if (this.commandStatus == 0) {
            this.readMandatory(decoder);
            int tlvLength = commandLen - (decoder.getParsePosition() - startPos);
            if (tlvLength > 0) {
                this.tlvTable.readFrom(decoder, tlvLength);
            }
        }
    }

    public final void validate(SMPPVersion smppVersion) {
        this.validateMandatory(smppVersion);
        if (smppVersion.isNewerThan(SMPPVersion.VERSION_5_0) && !this.validateTLVTable(smppVersion)) {
            throw new VersionException("Packet does not contain all required TLVs.");
        }
    }

    public String toString() {
        String packetName = this.getClass().getSimpleName();
        StringBuilder buffer = new StringBuilder();
        buffer.append(packetName).append("(Header:(length=").append(this.getLength()).append(",id=0x").append(Integer.toHexString(this.commandId)).append(",status=").append(this.commandStatus).append(",sequenceNum=").append(this.sequenceNum).append("),Mandatory:(");
        this.toString(buffer);
        buffer.append(") Optional:(").append(this.tlvTable).append("))");
        return buffer.toString();
    }

    public int sizeOf(Address address) {
        return address != null ? address.getLength() : 3;
    }

    public int sizeOf(SMPPDate date) {
        return date != null ? date.getLength() : 1;
    }

    public int sizeOf(byte[] array) {
        return array != null ? array.length : 0;
    }

    public int sizeOf(String string) {
        return string != null ? string.length() : 0;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || this.getClass() != obj.getClass()) {
            return false;
        }
        SMPPPacket other = (SMPPPacket)obj;
        return this.commandId == other.commandId && this.commandStatus == other.commandStatus && this.sequenceNum == other.sequenceNum;
    }

    public int hashCode() {
        return new Integer(this.commandId).hashCode() + new Integer(this.commandStatus).hashCode() + new Long(this.sequenceNum).hashCode();
    }

    protected boolean safeCompare(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        return obj1.equals(obj2);
    }

    protected void toString(StringBuilder buffer) {
    }

    protected void validateMandatory(SMPPVersion smppVersion) {
    }

    protected boolean validateTLVTable(SMPPVersion smppVersion) {
        return true;
    }

    protected void readMandatory(PacketDecoder decoder) {
    }

    protected void writeMandatory(PacketEncoder encoder) throws IOException {
    }

    protected int getMandatorySize() {
        return 0;
    }

    private int readHeader(PacketDecoder decoder) {
        if (decoder.getAvailableBytes() < 16) {
            throw new SMPPProtocolException("Not enough bytes for a header: " + decoder.getAvailableBytes());
        }
        int commandLen = (int)decoder.readUInt4();
        if (commandLen < 0) {
            throw new SMPPProtocolException("Packet is too large for smppapi!");
        }
        int id = (int)decoder.readUInt4();
        if (id != this.commandId) {
            throw new SMPPRuntimeException("Packet of type " + this.getClass().getName() + " cannot parse commandId " + this.commandId);
        }
        this.commandStatus = (int)decoder.readUInt4();
        this.sequenceNum = (int)decoder.readUInt4();
        return commandLen;
    }
}

