/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.message;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.mobicents.protocols.smpp.Address;
import org.mobicents.protocols.smpp.message.SMPPPacket;
import org.mobicents.protocols.smpp.util.PacketDecoder;
import org.mobicents.protocols.smpp.util.PacketEncoder;
import org.mobicents.protocols.smpp.util.SMPPDate;
import org.mobicents.protocols.smpp.version.SMPPVersion;

public class ReplaceSM
extends SMPPPacket {
    private static final long serialVersionUID = 2L;
    private String messageId;
    private Address source;
    private SMPPDate deliveryTime;
    private SMPPDate expiryTime;
    private int registered;
    private int defaultMsg;
    private byte[] message;

    public ReplaceSM() {
        super(7);
    }

    public int getDefaultMsg() {
        return this.defaultMsg;
    }

    public void setDefaultMsg(int defaultMsg) {
        this.defaultMsg = defaultMsg;
    }

    public SMPPDate getDeliveryTime() {
        return this.deliveryTime;
    }

    public void setDeliveryTime(SMPPDate deliveryTime) {
        this.deliveryTime = deliveryTime;
    }

    public SMPPDate getExpiryTime() {
        return this.expiryTime;
    }

    public void setExpiryTime(SMPPDate expiryTime) {
        this.expiryTime = expiryTime;
    }

    public byte[] getMessage() {
        return this.message;
    }

    public void setMessage(byte[] message) {
        this.message = message;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public int getRegistered() {
        return this.registered;
    }

    public void setRegistered(int registered) {
        this.registered = registered;
    }

    public Address getSource() {
        return this.source;
    }

    public void setSource(Address source) {
        this.source = source;
    }

    public int getMessageLen() {
        return this.sizeOf(this.message);
    }

    public boolean equals(Object obj) {
        boolean equals = super.equals(obj);
        if (equals) {
            ReplaceSM other = (ReplaceSM)obj;
            equals |= this.safeCompare(this.messageId, other.messageId);
            equals |= this.safeCompare(this.source, other.source);
            equals |= this.safeCompare(this.deliveryTime, other.deliveryTime);
            equals |= this.safeCompare(this.expiryTime, other.expiryTime);
            equals |= this.registered == other.registered;
            equals |= this.defaultMsg == other.defaultMsg;
            equals |= Arrays.equals(this.message, other.message);
        }
        return equals;
    }

    public int hashCode() {
        int hc = super.hashCode();
        hc += this.messageId != null ? this.messageId.hashCode() : 0;
        hc += this.source != null ? this.source.hashCode() : 0;
        hc += this.deliveryTime != null ? this.deliveryTime.hashCode() : 0;
        hc += this.expiryTime != null ? this.expiryTime.hashCode() : 0;
        hc += Integer.valueOf(this.registered).hashCode();
        hc += Integer.valueOf(this.defaultMsg).hashCode();
        if (this.message != null) {
            try {
                hc += new String(this.message, "US-ASCII").hashCode();
            }
            catch (UnsupportedEncodingException x) {
                throw new RuntimeException(x);
            }
        }
        return hc;
    }

    protected void toString(StringBuilder buffer) {
        buffer.append("messageId=").append(this.messageId).append(",source=").append(this.source).append(",deliveryTime=").append(this.deliveryTime).append(",expiryTime=").append(this.expiryTime).append(",registered=").append(this.registered).append(",defaultMsg=").append(this.defaultMsg).append(",length=").append(this.getMessageLen()).append(",message=").append(this.message);
    }

    protected void validateMandatory(SMPPVersion smppVersion) {
        smppVersion.validateMessageId(this.messageId);
        smppVersion.validateAddress(this.source);
        smppVersion.validateRegisteredDelivery(this.registered);
        smppVersion.validateDefaultMsg(this.defaultMsg);
        smppVersion.validateMessage(this.message, 0, this.getMessageLen());
    }

    protected void readMandatory(PacketDecoder decoder) {
        this.messageId = decoder.readCString();
        this.source = decoder.readAddress();
        this.deliveryTime = decoder.readDate();
        this.expiryTime = decoder.readDate();
        this.registered = decoder.readUInt1();
        this.defaultMsg = decoder.readUInt1();
        int len = decoder.readUInt1();
        this.message = decoder.readBytes(len);
    }

    protected void writeMandatory(PacketEncoder encoder) throws IOException {
        encoder.writeCString(this.messageId);
        encoder.writeAddress(this.source);
        encoder.writeDate(this.deliveryTime);
        encoder.writeDate(this.expiryTime);
        encoder.writeUInt1(this.registered);
        encoder.writeUInt1(this.defaultMsg);
        int len = this.message != null ? this.message.length : 0;
        encoder.writeUInt1(len);
        encoder.writeBytes(this.message, 0, len);
    }

    protected int getMandatorySize() {
        int length = 4;
        length += this.sizeOf(this.messageId);
        length += this.sizeOf(this.source);
        length += this.sizeOf(this.deliveryTime);
        length += this.sizeOf(this.expiryTime);
        return length += this.sizeOf(this.message);
    }
}

