/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.message;

import java.io.IOException;
import org.mobicents.protocols.smpp.message.MessageState;
import org.mobicents.protocols.smpp.message.SMPPPacket;
import org.mobicents.protocols.smpp.util.PacketDecoder;
import org.mobicents.protocols.smpp.util.PacketEncoder;
import org.mobicents.protocols.smpp.util.SMPPDate;
import org.mobicents.protocols.smpp.version.SMPPVersion;

public class QuerySMResp
extends SMPPPacket {
    private static final long serialVersionUID = 2L;
    private String messageId;
    private SMPPDate finalDate;
    private MessageState messageState = MessageState.UNKNOWN;
    private int errorCode;

    public QuerySMResp() {
        super(-2147483645);
    }

    public QuerySMResp(SMPPPacket request) {
        super(request);
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public SMPPDate getFinalDate() {
        return this.finalDate;
    }

    public void setFinalDate(SMPPDate finalDate) {
        this.finalDate = finalDate;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public MessageState getMessageState() {
        return this.messageState;
    }

    public void setMessageState(MessageState messageState) {
        this.messageState = messageState;
    }

    public boolean equals(Object obj) {
        boolean equals = super.equals(obj);
        if (equals) {
            QuerySMResp other = (QuerySMResp)obj;
            equals |= this.safeCompare(this.messageId, other.messageId);
            equals |= this.safeCompare(this.finalDate, other.finalDate);
            equals |= this.messageState == other.messageState;
            equals |= this.errorCode == other.errorCode;
        }
        return equals;
    }

    public int hashCode() {
        int hc = super.hashCode();
        hc += this.messageId != null ? this.messageId.hashCode() : 0;
        hc += this.finalDate != null ? this.finalDate.hashCode() : 0;
        hc += Integer.valueOf(this.messageState.getValue()).hashCode();
        return hc += Integer.valueOf(this.errorCode).hashCode();
    }

    protected void toString(StringBuilder buffer) {
        buffer.append("messageId=").append(this.messageId).append(",finalDate=").append(this.finalDate).append(",messageState=").append(this.messageState).append(",errorCode=").append(this.errorCode);
    }

    protected void validateMandatory(SMPPVersion smppVersion) {
        smppVersion.validateMessageId(this.messageId);
        smppVersion.validateErrorCode(this.errorCode);
    }

    protected void readMandatory(PacketDecoder decoder) {
        this.messageId = decoder.readCString();
        this.finalDate = decoder.readDate();
        this.messageState = MessageState.getMessageState(decoder.readUInt1());
        this.errorCode = decoder.readUInt1();
    }

    protected void writeMandatory(PacketEncoder encoder) throws IOException {
        encoder.writeCString(this.messageId);
        encoder.writeDate(this.finalDate);
        encoder.writeUInt1(this.messageState.getValue());
        encoder.writeUInt1(this.errorCode);
    }

    protected int getMandatorySize() {
        int length = 3;
        length += this.sizeOf(this.messageId);
        return length += this.sizeOf(this.finalDate);
    }
}

