/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.message;

import java.io.IOException;
import org.mobicents.protocols.smpp.Address;
import org.mobicents.protocols.smpp.message.SMPPPacket;
import org.mobicents.protocols.smpp.util.PacketDecoder;
import org.mobicents.protocols.smpp.util.PacketEncoder;
import org.mobicents.protocols.smpp.version.SMPPVersion;

public class QuerySM
extends SMPPPacket {
    private static final long serialVersionUID = 2L;
    private String messageId;
    private Address source;

    public QuerySM() {
        super(3);
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public Address getSource() {
        return this.source;
    }

    public void setSource(Address source) {
        this.source = source;
    }

    public boolean equals(Object obj) {
        boolean equals = super.equals(obj);
        if (equals) {
            QuerySM other = (QuerySM)obj;
            equals |= this.safeCompare(this.messageId, other.messageId);
            equals |= this.safeCompare(this.source, other.source);
        }
        return equals;
    }

    public int hashCode() {
        int hc = super.hashCode();
        hc += this.messageId != null ? this.messageId.hashCode() : 0;
        return hc += this.source != null ? this.source.hashCode() : 0;
    }

    protected void toString(StringBuilder buffer) {
        buffer.append("messageId=").append(this.messageId).append(",source=").append(this.source);
    }

    protected void validateMandatory(SMPPVersion smppVersion) {
        smppVersion.validateMessageId(this.messageId);
        smppVersion.validateAddress(this.source);
    }

    protected void readMandatory(PacketDecoder decoder) {
        this.messageId = decoder.readCString();
        this.source = decoder.readAddress();
    }

    protected void writeMandatory(PacketEncoder encoder) throws IOException {
        encoder.writeCString(this.messageId);
        encoder.writeAddress(this.source);
    }

    protected int getMandatorySize() {
        return 1 + this.sizeOf(this.messageId) + this.sizeOf(this.source);
    }
}

