/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.message;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.mobicents.protocols.smpp.Address;
import org.mobicents.protocols.smpp.message.DestinationTable;
import org.mobicents.protocols.smpp.message.MessageState;
import org.mobicents.protocols.smpp.message.SMPPPacket;
import org.mobicents.protocols.smpp.util.PacketDecoder;
import org.mobicents.protocols.smpp.util.PacketEncoder;
import org.mobicents.protocols.smpp.util.SMPPDate;
import org.mobicents.protocols.smpp.version.SMPPVersion;

public class QueryMsgDetailsResp
extends SMPPPacket {
    private static final long serialVersionUID = 2L;
    private String serviceType;
    private Address source;
    private DestinationTable destinationTable = new DestinationTable();
    private int protocolID;
    private int priority;
    private SMPPDate deliveryTime;
    private SMPPDate expiryTime;
    private int registered;
    private int dataCoding;
    private byte[] message;
    private String messageId;
    private SMPPDate finalDate;
    private MessageState messageStatus = MessageState.UNKNOWN;
    private int errorCode;

    public QueryMsgDetailsResp() {
        super(-2147483612);
    }

    public QueryMsgDetailsResp(SMPPPacket request) {
        super(request);
    }

    public int getDataCoding() {
        return this.dataCoding;
    }

    public void setDataCoding(int dataCoding) {
        this.dataCoding = dataCoding;
    }

    public SMPPDate getDeliveryTime() {
        return this.deliveryTime;
    }

    public void setDeliveryTime(SMPPDate deliveryTime) {
        this.deliveryTime = deliveryTime;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public SMPPDate getExpiryTime() {
        return this.expiryTime;
    }

    public void setExpiryTime(SMPPDate expiryTime) {
        this.expiryTime = expiryTime;
    }

    public SMPPDate getFinalDate() {
        return this.finalDate;
    }

    public void setFinalDate(SMPPDate finalDate) {
        this.finalDate = finalDate;
    }

    public byte[] getMessage() {
        return this.message;
    }

    public void setMessage(byte[] message) {
        this.message = message;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public MessageState getMessageStatus() {
        return this.messageStatus;
    }

    public void setMessageStatus(MessageState messageStatus) {
        this.messageStatus = messageStatus;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getProtocolID() {
        return this.protocolID;
    }

    public void setProtocolID(int protocolID) {
        this.protocolID = protocolID;
    }

    public int getRegistered() {
        return this.registered;
    }

    public void setRegistered(int registered) {
        this.registered = registered;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public Address getSource() {
        return this.source;
    }

    public void setSource(Address source) {
        this.source = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addDestination(Address address) {
        DestinationTable destinationTable = this.destinationTable;
        synchronized (destinationTable) {
            this.destinationTable.add(address);
            return this.destinationTable.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addDestination(String distributionList) {
        DestinationTable destinationTable = this.destinationTable;
        synchronized (destinationTable) {
            this.destinationTable.add(distributionList);
            return this.destinationTable.size();
        }
    }

    public int getNumDests() {
        return this.destinationTable.size();
    }

    public DestinationTable getDestinationTable() {
        return this.destinationTable;
    }

    public boolean equals(Object obj) {
        boolean equals = super.equals(obj);
        if (equals) {
            QueryMsgDetailsResp other = (QueryMsgDetailsResp)obj;
            equals |= this.safeCompare(this.serviceType, other.serviceType);
            equals |= this.safeCompare(this.source, other.source);
            equals |= this.safeCompare(this.destinationTable, other.destinationTable);
            equals |= this.protocolID == other.protocolID;
            equals |= this.priority == other.priority;
            equals |= this.safeCompare(this.deliveryTime, other.deliveryTime);
            equals |= this.safeCompare(this.expiryTime, other.expiryTime);
            equals |= this.registered == other.registered;
            equals |= this.dataCoding == other.dataCoding;
            equals |= Arrays.equals(this.message, other.message);
            equals |= this.messageId == other.messageId;
            equals |= this.safeCompare(this.finalDate, other.finalDate);
            equals |= this.messageStatus == other.messageStatus;
            equals |= this.errorCode == other.errorCode;
        }
        return equals;
    }

    public int hashCode() {
        int hc = super.hashCode();
        hc += this.serviceType != null ? this.serviceType.hashCode() : 0;
        hc += this.source != null ? this.source.hashCode() : 0;
        hc += this.destinationTable != null ? this.destinationTable.hashCode() : 13;
        hc += Integer.valueOf(this.protocolID).hashCode();
        hc += Integer.valueOf(this.priority).hashCode();
        hc += this.deliveryTime != null ? this.deliveryTime.hashCode() : 0;
        hc += this.expiryTime != null ? this.expiryTime.hashCode() : 0;
        hc += Integer.valueOf(this.registered).hashCode();
        hc += Integer.valueOf(this.dataCoding).hashCode();
        if (this.message != null) {
            try {
                hc += new String(this.message, "US-ASCII").hashCode();
            }
            catch (UnsupportedEncodingException x) {
                throw new RuntimeException(x);
            }
        }
        hc += Integer.valueOf(this.messageId).hashCode();
        hc += this.finalDate != null ? this.finalDate.hashCode() : 0;
        hc += Integer.valueOf(this.messageStatus.getValue()).hashCode();
        return hc += Integer.valueOf(this.errorCode).hashCode();
    }

    protected void toString(StringBuilder buffer) {
        buffer.append("serviceType=").append(this.serviceType).append(",source=").append(this.source).append(",numberOfDests=").append(this.destinationTable.size()).append(",destinations=").append(this.destinationTable).append(",protocolID=").append(this.protocolID).append(",priority=").append(this.priority).append(",deliveryTime=").append(this.deliveryTime).append(",expiryTime=").append(this.expiryTime).append(",registered=").append(this.registered).append(",dataCoding=").append(this.dataCoding).append(",smLength=").append(this.sizeOf(this.message)).append(",message=").append(this.message).append(",messageId=").append(this.messageId).append(",finalDate=").append(this.finalDate).append(",messageStatus=").append(this.messageStatus).append(",errorCode=").append(this.errorCode);
    }

    protected void validateMandatory(SMPPVersion smppVersion) {
        smppVersion.validateServiceType(this.serviceType);
        smppVersion.validateAddress(this.source);
        smppVersion.validateNumberOfDests(this.destinationTable.size());
        for (Address address : this.destinationTable.getAddresses()) {
            smppVersion.validateAddress(address);
        }
        for (String distList : this.destinationTable.getDistributionLists()) {
            smppVersion.validateDistListName(distList);
        }
        smppVersion.validateProtocolID(this.protocolID);
        smppVersion.validatePriorityFlag(this.priority);
        smppVersion.validateRegisteredDelivery(this.registered);
        smppVersion.validateDataCoding(this.dataCoding);
        smppVersion.validateMessage(this.message, 0, this.sizeOf(this.message));
        smppVersion.validateMessageId(this.messageId);
        smppVersion.validateErrorCode(this.errorCode);
    }

    protected void readMandatory(PacketDecoder decoder) {
        this.serviceType = decoder.readCString();
        this.source = decoder.readAddress();
        int tableSize = decoder.readUInt1();
        this.destinationTable = new DestinationTable();
        this.destinationTable.readFrom(decoder, tableSize);
        this.protocolID = decoder.readUInt1();
        this.priority = decoder.readUInt1();
        this.deliveryTime = decoder.readDate();
        this.expiryTime = decoder.readDate();
        this.registered = decoder.readUInt1();
        this.dataCoding = decoder.readUInt1();
        int messageLen = decoder.readUInt1();
        this.message = decoder.readBytes(messageLen);
        this.messageId = decoder.readCString();
        this.finalDate = decoder.readDate();
        this.messageStatus = MessageState.getMessageState(decoder.readUInt1());
        this.errorCode = decoder.readUInt1();
    }

    protected void writeMandatory(PacketEncoder encoder) throws IOException {
        encoder.writeCString(this.serviceType);
        encoder.writeAddress(this.source);
        encoder.writeUInt1(this.destinationTable.size());
        this.destinationTable.writeTo(encoder);
        encoder.writeUInt1(this.protocolID);
        encoder.writeUInt1(this.priority);
        encoder.writeDate(this.deliveryTime);
        encoder.writeDate(this.expiryTime);
        encoder.writeUInt1(this.registered);
        encoder.writeUInt1(this.dataCoding);
        int messageLen = this.message != null ? this.message.length : 0;
        encoder.writeUInt1(messageLen);
        encoder.writeBytes(this.message, 0, messageLen);
        encoder.writeCString(this.messageId);
        encoder.writeDate(this.finalDate);
        encoder.writeUInt1(this.messageStatus.getValue());
        encoder.writeUInt1(this.errorCode);
    }

    protected int getMandatorySize() {
        int length = 10;
        length += this.sizeOf(this.serviceType);
        length += this.sizeOf(this.source);
        length += this.destinationTable.getLength();
        length += this.sizeOf(this.deliveryTime);
        length += this.sizeOf(this.expiryTime);
        length += this.sizeOf(this.message);
        length += this.sizeOf(this.messageId);
        return length += this.sizeOf(this.finalDate);
    }
}

