/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.message;

import java.io.IOException;
import org.mobicents.protocols.smpp.Address;
import org.mobicents.protocols.smpp.message.SMPPPacket;
import org.mobicents.protocols.smpp.util.PacketDecoder;
import org.mobicents.protocols.smpp.util.PacketEncoder;
import org.mobicents.protocols.smpp.version.SMPPVersion;

public class QueryMsgDetails
extends SMPPPacket {
    private static final long serialVersionUID = 2L;
    private String messageId;
    private Address source;
    private int smLength;

    public QueryMsgDetails() {
        super(36);
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public Address getSource() {
        return this.source;
    }

    public void setSource(Address source) {
        this.source = source;
    }

    public void setSmLength(int len) {
        this.smLength = len < 0 ? 0 : (len > 160 ? 160 : len);
    }

    public int getSmLength() {
        return this.smLength;
    }

    public boolean equals(Object obj) {
        boolean equals = super.equals(obj);
        if (equals) {
            QueryMsgDetails other = (QueryMsgDetails)obj;
            equals |= this.safeCompare(this.messageId, other.messageId);
            equals |= this.safeCompare(this.source, other.source);
            equals |= this.smLength == other.smLength;
        }
        return equals;
    }

    public int hashCode() {
        int hc = super.hashCode();
        hc += this.messageId != null ? this.messageId.hashCode() : 0;
        hc += this.source != null ? this.source.hashCode() : 0;
        return hc += Integer.valueOf(this.smLength).hashCode();
    }

    protected void toString(StringBuilder buffer) {
        buffer.append("messageId=").append(this.messageId).append(",source=").append(this.source).append(",smLength=").append(this.smLength);
    }

    protected void validateMandatory(SMPPVersion smppVersion) {
        smppVersion.validateMessageId(this.messageId);
        smppVersion.validateAddress(this.source);
    }

    protected void readMandatory(PacketDecoder decoder) {
        this.messageId = decoder.readCString();
        this.source = decoder.readAddress();
        this.smLength = decoder.readUInt1();
    }

    protected void writeMandatory(PacketEncoder encoder) throws IOException {
        encoder.writeCString(this.messageId);
        encoder.writeAddress(this.source);
        encoder.writeUInt1(this.smLength);
    }

    protected int getMandatorySize() {
        int length = 2;
        length += this.sizeOf(this.messageId);
        return length += this.sizeOf(this.source);
    }
}

