/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.message;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.mobicents.protocols.smpp.message.SMPPPacket;
import org.mobicents.protocols.smpp.util.PacketDecoder;
import org.mobicents.protocols.smpp.util.PacketEncoder;

public class QueryLastMsgsResp
extends SMPPPacket {
    private static final long serialVersionUID = 2L;
    private static final int MAX_SIZE = 255;
    private List<String> messageTable = new ArrayList<String>();

    public QueryLastMsgsResp() {
        super(-2147483613);
    }

    public QueryLastMsgsResp(SMPPPacket request) {
        super(request);
    }

    public int addMessageId(String id) {
        if (this.messageTable.size() < 255) {
            this.messageTable.add(id);
        }
        return this.messageTable.size();
    }

    public int getMsgCount() {
        return this.messageTable.size();
    }

    public String[] getMessageIds() {
        return this.messageTable.toArray(new String[0]);
    }

    public boolean equals(Object obj) {
        boolean equals = super.equals(obj);
        if (equals) {
            QueryLastMsgsResp other = (QueryLastMsgsResp)obj;
            equals |= this.safeCompare(this.messageTable, other.messageTable);
        }
        return equals;
    }

    public int hashCode() {
        int hc = super.hashCode();
        return hc += this.messageTable != null ? ((Object)this.messageTable).hashCode() : 71;
    }

    protected void toString(StringBuilder buffer) {
        buffer.append("msgCount=").append(this.messageTable.size()).append(",messageIds=").append(this.messageTable);
    }

    protected void readMandatory(PacketDecoder decoder) {
        this.messageTable = new ArrayList<String>();
        int count = decoder.readUInt1();
        for (int i = 0; i < count; ++i) {
            this.messageTable.add(decoder.readCString());
        }
    }

    protected void writeMandatory(PacketEncoder encoder) throws IOException {
        int count = this.messageTable.size();
        encoder.writeUInt1(count);
        for (String s : this.messageTable) {
            encoder.writeCString(s);
        }
    }

    protected int getMandatorySize() {
        int length = 1;
        for (String s : this.messageTable) {
            length += 1 + this.sizeOf(s);
        }
        return length;
    }
}

