/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.message;

import java.io.IOException;
import org.mobicents.protocols.smpp.Address;
import org.mobicents.protocols.smpp.message.SMPPPacket;
import org.mobicents.protocols.smpp.util.PacketDecoder;
import org.mobicents.protocols.smpp.util.PacketEncoder;
import org.mobicents.protocols.smpp.version.SMPPVersion;

public class QueryLastMsgs
extends SMPPPacket {
    private static final long serialVersionUID = 2L;
    private Address source;
    private int msgCount;

    public QueryLastMsgs() {
        super(35);
    }

    public Address getSource() {
        return this.source;
    }

    public void setSource(Address source) {
        this.source = source;
    }

    public int getMsgCount() {
        return this.msgCount;
    }

    public void setMsgCount(int msgCount) {
        this.msgCount = msgCount < 1 ? 1 : (msgCount > 100 ? 100 : msgCount);
    }

    public boolean equals(Object obj) {
        boolean equals = super.equals(obj);
        if (equals) {
            QueryLastMsgs other = (QueryLastMsgs)obj;
            equals |= this.safeCompare(this.source, other.source);
            equals |= this.msgCount == other.msgCount;
        }
        return equals;
    }

    public int hashCode() {
        int hc = super.hashCode();
        hc += this.source != null ? this.source.hashCode() : 0;
        return hc += Integer.valueOf(this.msgCount).hashCode();
    }

    protected void toString(StringBuilder buffer) {
        buffer.append("source=").append(this.source).append("msgCount=").append(this.msgCount);
    }

    protected void validateMandatory(SMPPVersion smppVersion) {
        smppVersion.validateAddress(this.source);
    }

    protected void readMandatory(PacketDecoder decoder) {
        this.source = decoder.readAddress();
        this.msgCount = decoder.readUInt1();
    }

    protected void writeMandatory(PacketEncoder encoder) throws IOException {
        encoder.writeAddress(this.source);
        encoder.writeUInt1(this.msgCount);
    }

    protected int getMandatorySize() {
        int length = 1;
        return length += this.sizeOf(this.source);
    }
}

