/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.message;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.mobicents.protocols.smpp.Address;
import org.mobicents.protocols.smpp.util.PacketDecoder;
import org.mobicents.protocols.smpp.util.PacketEncoder;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DestinationTable
implements Serializable {
    private static final long serialVersionUID = 2L;
    private List<Address> addresses = new ArrayList<Address>();
    private List<String> distributionLists = new ArrayList<String>();
    private int length;

    public void add(Address addr) {
        this.addresses.add(addr);
        this.length += addr.getLength() + 1;
    }

    public void add(String distributionList) {
        this.distributionLists.add(distributionList);
        this.length += distributionList.length() + 2;
    }

    public void remove(Address addr) {
        int i = this.addresses.indexOf(addr);
        if (i > -1) {
            this.length -= this.addresses.remove(i).getLength() + 1;
        }
    }

    public void remove(String distributionList) {
        int i = this.distributionLists.indexOf(distributionList);
        if (i > -1) {
            this.length -= this.distributionLists.remove(i).length() + 2;
        }
    }

    public int getLength() {
        return this.length;
    }

    public int size() {
        return this.addresses.size() + this.distributionLists.size();
    }

    public Collection<Address> getAddresses() {
        return Collections.unmodifiableCollection(this.addresses);
    }

    public Collection<String> getDistributionLists() {
        return Collections.unmodifiableCollection(this.distributionLists);
    }

    public void writeTo(PacketEncoder encoder) throws IOException {
        for (Address address : this.addresses) {
            encoder.writeUInt1(1);
            encoder.writeAddress(address);
        }
        for (String list : this.distributionLists) {
            encoder.writeUInt1(2);
            encoder.writeCString(list);
        }
    }

    public void readFrom(PacketDecoder decoder, int count) {
        for (int i = 0; i < count; ++i) {
            int type = decoder.readUInt1();
            if (type == 1) {
                this.addresses.add(decoder.readAddress());
                continue;
            }
            if (type == 2) {
                this.distributionLists.add(decoder.readCString());
                continue;
            }
            LoggerFactory.getLogger(DestinationTable.class).warn("Unidentified destination type on input.");
        }
        this.calculateLength();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof DestinationTable)) {
            return false;
        }
        DestinationTable other = (DestinationTable)obj;
        return this.length == other.length && ((Object)this.addresses).equals(other.addresses) && ((Object)this.distributionLists).equals(other.distributionLists);
    }

    public int hashCode() {
        return ((Object)this.addresses).hashCode() + ((Object)this.distributionLists).hashCode();
    }

    public String toString() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(this.addresses);
        list.addAll(this.distributionLists);
        return ((Object)list).toString();
    }

    private void calculateLength() {
        this.length = this.addresses.size() + this.distributionLists.size() * 2;
        for (Address address : this.addresses) {
            this.length += address.getLength();
        }
        for (String list : this.distributionLists) {
            this.length += list.length();
        }
    }
}

