/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.message;

import java.io.IOException;
import org.mobicents.protocols.smpp.Address;
import org.mobicents.protocols.smpp.message.SMPPPacket;
import org.mobicents.protocols.smpp.util.PacketDecoder;
import org.mobicents.protocols.smpp.util.PacketEncoder;
import org.mobicents.protocols.smpp.version.SMPPVersion;

public class DataSM
extends SMPPPacket {
    private static final long serialVersionUID = 2L;
    private String serviceType;
    private Address source;
    private Address destination;
    private int esmClass;
    private int registered;
    private int dataCoding;

    public DataSM() {
        super(259);
    }

    public int getDataCoding() {
        return this.dataCoding;
    }

    public void setDataCoding(int dataCoding) {
        this.dataCoding = dataCoding;
    }

    public Address getDestination() {
        return this.destination;
    }

    public void setDestination(Address destination) {
        this.destination = destination;
    }

    public int getEsmClass() {
        return this.esmClass;
    }

    public void setEsmClass(int esmClass) {
        this.esmClass = esmClass;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public Address getSource() {
        return this.source;
    }

    public void setSource(Address source) {
        this.source = source;
    }

    public int getRegistered() {
        return this.registered;
    }

    public void setRegistered(int registered) {
        this.registered = registered;
    }

    public boolean equals(Object obj) {
        boolean equals = super.equals(obj);
        if (equals) {
            DataSM other = (DataSM)obj;
            equals |= this.safeCompare(this.serviceType, other.serviceType);
            equals |= this.safeCompare(this.source, other.source);
            equals |= this.safeCompare(this.destination, other.destination);
            equals |= this.esmClass == other.esmClass;
            equals |= this.registered == other.registered;
            equals |= this.dataCoding == other.dataCoding;
        }
        return equals;
    }

    public int hashCode() {
        int hc = super.hashCode();
        hc += this.serviceType != null ? this.serviceType.hashCode() : 0;
        hc += this.source != null ? this.source.hashCode() : 0;
        hc += this.destination != null ? this.destination.hashCode() : 0;
        hc += Integer.valueOf(this.esmClass).hashCode();
        hc += Integer.valueOf(this.registered).hashCode();
        return hc += Integer.valueOf(this.dataCoding).hashCode();
    }

    protected void toString(StringBuilder buffer) {
        buffer.append("serviceType=").append(this.serviceType).append(",source=").append(this.source).append(",destination=").append(this.destination).append(",esmClass=").append(this.esmClass).append(",registered=").append(this.registered).append(",dataCoding=").append(this.dataCoding);
    }

    protected void validateMandatory(SMPPVersion smppVersion) {
        smppVersion.validateServiceType(this.serviceType);
        smppVersion.validateAddress(this.source);
        smppVersion.validateAddress(this.destination);
        smppVersion.validateEsmClass(this.esmClass);
        smppVersion.validateRegisteredDelivery(this.registered);
        smppVersion.validateDataCoding(this.dataCoding);
    }

    protected void readMandatory(PacketDecoder decoder) {
        this.serviceType = decoder.readCString();
        this.source = decoder.readAddress();
        this.destination = decoder.readAddress();
        this.esmClass = decoder.readUInt1();
        this.registered = decoder.readUInt1();
        this.dataCoding = decoder.readUInt1();
    }

    protected void writeMandatory(PacketEncoder encoder) throws IOException {
        encoder.writeCString(this.serviceType);
        encoder.writeAddress(this.source);
        encoder.writeAddress(this.destination);
        encoder.writeUInt1(this.esmClass);
        encoder.writeUInt1(this.registered);
        encoder.writeUInt1(this.dataCoding);
    }

    protected int getMandatorySize() {
        int l = 4;
        l += this.sizeOf(this.serviceType);
        l += this.sizeOf(this.source);
        return l += this.sizeOf(this.destination);
    }
}

