/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.message;

import java.io.IOException;
import org.mobicents.protocols.smpp.Address;
import org.mobicents.protocols.smpp.message.SMPPPacket;
import org.mobicents.protocols.smpp.util.PacketDecoder;
import org.mobicents.protocols.smpp.util.PacketEncoder;
import org.mobicents.protocols.smpp.version.SMPPVersion;

public class CancelSM
extends SMPPPacket {
    private static final long serialVersionUID = 2L;
    private String serviceType;
    private String messageId;
    private Address source;
    private Address destination;

    public CancelSM() {
        super(8);
    }

    public Address getDestination() {
        return this.destination;
    }

    public void setDestination(Address destination) {
        this.destination = destination;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public Address getSource() {
        return this.source;
    }

    public void setSource(Address source) {
        this.source = source;
    }

    public boolean equals(Object obj) {
        boolean equals = super.equals(obj);
        if (equals) {
            CancelSM other = (CancelSM)obj;
            equals |= this.safeCompare(this.serviceType, other.serviceType);
            equals |= this.safeCompare(this.messageId, other.messageId);
            equals |= this.safeCompare(this.source, other.source);
            equals |= this.safeCompare(this.destination, other.destination);
        }
        return equals;
    }

    public int hashCode() {
        int hc = super.hashCode();
        hc += this.serviceType != null ? this.serviceType.hashCode() : 0;
        hc += this.messageId != null ? this.messageId.hashCode() : 0;
        hc += this.source != null ? this.source.hashCode() : 0;
        return hc += this.destination != null ? this.destination.hashCode() : 0;
    }

    protected void toString(StringBuilder buffer) {
        buffer.append("serviceType=").append(this.serviceType).append(",messageId=").append(this.messageId).append(",source=").append(this.source).append(",destination=").append(this.destination);
    }

    protected void validateMandatory(SMPPVersion smppVersion) {
        smppVersion.validateServiceType(this.serviceType);
        smppVersion.validateMessageId(this.messageId);
        smppVersion.validateAddress(this.source);
        smppVersion.validateAddress(this.destination);
    }

    protected void readMandatory(PacketDecoder decoder) {
        this.serviceType = decoder.readCString();
        this.messageId = decoder.readCString();
        this.source = decoder.readAddress();
        this.destination = decoder.readAddress();
    }

    protected void writeMandatory(PacketEncoder encoder) throws IOException {
        encoder.writeCString(this.serviceType);
        encoder.writeCString(this.messageId);
        encoder.writeAddress(this.source);
        encoder.writeAddress(this.destination);
    }

    protected int getMandatorySize() {
        int length = 2;
        length += this.sizeOf(this.serviceType);
        length += this.sizeOf(this.messageId);
        length += this.sizeOf(this.source);
        return length += this.sizeOf(this.destination);
    }
}

