/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.message;

import java.io.IOException;
import org.mobicents.protocols.smpp.Address;
import org.mobicents.protocols.smpp.message.SMPPPacket;
import org.mobicents.protocols.smpp.message.tlv.TLVTable;
import org.mobicents.protocols.smpp.message.tlv.Tag;
import org.mobicents.protocols.smpp.util.PacketDecoder;
import org.mobicents.protocols.smpp.util.PacketEncoder;
import org.mobicents.protocols.smpp.util.SMPPDate;
import org.mobicents.protocols.smpp.version.SMPPVersion;

public class BroadcastSM
extends SMPPPacket {
    private static final long serialVersionUID = 2L;
    private String serviceType;
    private Address source;
    private String messageId;
    private int priority;
    private SMPPDate deliveryTime;
    private SMPPDate expiryTime;
    private int replaceIfPresent;
    private int dataCoding;
    private int defaultMsg;

    public BroadcastSM() {
        super(273);
    }

    public int getDataCoding() {
        return this.dataCoding;
    }

    public void setDataCoding(int dataCoding) {
        this.dataCoding = dataCoding;
    }

    public int getDefaultMsg() {
        return this.defaultMsg;
    }

    public void setDefaultMsg(int defaultMsg) {
        this.defaultMsg = defaultMsg;
    }

    public SMPPDate getDeliveryTime() {
        return this.deliveryTime;
    }

    public void setDeliveryTime(SMPPDate deliveryTime) {
        this.deliveryTime = deliveryTime;
    }

    public SMPPDate getExpiryTime() {
        return this.expiryTime;
    }

    public void setExpiryTime(SMPPDate expiryTime) {
        this.expiryTime = expiryTime;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getReplaceIfPresent() {
        return this.replaceIfPresent;
    }

    public void setReplaceIfPresent(int replaceIfPresent) {
        this.replaceIfPresent = replaceIfPresent;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public Address getSource() {
        return this.source;
    }

    public void setSource(Address source) {
        this.source = source;
    }

    public boolean equals(Object obj) {
        boolean equals = super.equals(obj);
        if (equals) {
            BroadcastSM other = (BroadcastSM)obj;
            equals |= this.safeCompare(this.serviceType, other.serviceType);
            equals |= this.safeCompare(this.source, other.source);
            equals |= this.safeCompare(this.messageId, other.messageId);
            equals |= this.priority == other.priority;
            equals |= this.safeCompare(this.deliveryTime, other.deliveryTime);
            equals |= this.safeCompare(this.expiryTime, other.expiryTime);
            equals |= this.replaceIfPresent == other.replaceIfPresent;
            equals |= this.dataCoding == other.dataCoding;
            equals |= this.defaultMsg == other.defaultMsg;
        }
        return equals;
    }

    public int hashCode() {
        int hc = super.hashCode();
        hc += this.serviceType != null ? this.serviceType.hashCode() : 13;
        hc += this.source != null ? this.source.hashCode() : 13;
        hc += this.messageId != null ? this.messageId.hashCode() : 13;
        hc += Integer.valueOf(this.priority).hashCode();
        hc += this.deliveryTime != null ? this.deliveryTime.hashCode() : 13;
        hc += this.expiryTime != null ? this.expiryTime.hashCode() : 13;
        hc += Integer.valueOf(this.replaceIfPresent).hashCode();
        hc += Integer.valueOf(this.dataCoding).hashCode();
        return hc += Integer.valueOf(this.defaultMsg).hashCode();
    }

    protected void readMandatory(PacketDecoder decoder) {
        this.serviceType = decoder.readCString();
        this.source = decoder.readAddress();
        this.messageId = decoder.readCString();
        this.priority = decoder.readUInt1();
        this.deliveryTime = decoder.readDate();
        this.expiryTime = decoder.readDate();
        this.replaceIfPresent = decoder.readUInt1();
        this.dataCoding = decoder.readUInt1();
        this.defaultMsg = decoder.readUInt1();
    }

    protected void writeMandatory(PacketEncoder encoder) throws IOException {
        encoder.writeCString(this.serviceType);
        encoder.writeAddress(this.source);
        encoder.writeCString(this.messageId);
        encoder.writeUInt1(this.priority);
        encoder.writeDate(this.deliveryTime);
        encoder.writeDate(this.expiryTime);
        encoder.writeUInt1(this.replaceIfPresent);
        encoder.writeUInt1(this.dataCoding);
        encoder.writeUInt1(this.defaultMsg);
    }

    protected int getMandatorySize() {
        int length = 6;
        length += this.sizeOf(this.serviceType);
        length += this.sizeOf(this.source);
        length += this.sizeOf(this.messageId);
        length += this.sizeOf(this.deliveryTime);
        return length += this.sizeOf(this.expiryTime);
    }

    protected void validateMandatory(SMPPVersion smppVersion) {
        smppVersion.validateServiceType(this.serviceType);
        smppVersion.validateAddress(this.source);
        smppVersion.validateMessageId(this.messageId);
        smppVersion.validatePriorityFlag(this.priority);
        smppVersion.validateReplaceIfPresent(this.replaceIfPresent);
        smppVersion.validateDataCoding(this.dataCoding);
        smppVersion.validateDefaultMsg(this.defaultMsg);
    }

    protected boolean validateTLVTable(SMPPVersion version) {
        boolean valid = true;
        TLVTable tlvTable = this.getTLVTable();
        valid &= tlvTable.containsKey(Tag.BROADCAST_AREA_IDENTIFIER);
        valid &= tlvTable.containsKey(Tag.BROADCAST_CONTENT_TYPE);
        valid &= tlvTable.containsKey(Tag.BROADCAST_REP_NUM);
        return valid &= tlvTable.containsKey(Tag.BROADCAST_FREQUENCY_INTERVAL);
    }
}

