/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.message;

import java.io.IOException;
import org.mobicents.protocols.smpp.message.SMPPPacket;
import org.mobicents.protocols.smpp.util.PacketDecoder;
import org.mobicents.protocols.smpp.util.PacketEncoder;
import org.mobicents.protocols.smpp.version.SMPPVersion;
import org.mobicents.protocols.smpp.version.VersionFactory;

public abstract class Bind
extends SMPPPacket {
    private static final long serialVersionUID = 2L;
    private String systemId;
    private String password;
    private String systemType;
    private SMPPVersion version = VersionFactory.getDefaultVersion();
    private String addressRange;
    private int addressTon;
    private int addressNpi;

    public Bind(int id) {
        super(id);
    }

    public String getAddressRange() {
        return this.addressRange;
    }

    public void setAddressRange(String addressRange) {
        this.addressRange = addressRange;
    }

    public int getAddressNpi() {
        return this.addressNpi;
    }

    public void setAddressNpi(int addrNpi) {
        this.addressNpi = addrNpi;
    }

    public int getAddressTon() {
        return this.addressTon;
    }

    public void setAddressTon(int addrTon) {
        this.addressTon = addrTon;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getSystemType() {
        return this.systemType;
    }

    public void setSystemType(String systemType) {
        this.systemType = systemType;
    }

    public SMPPVersion getVersion() {
        return this.version;
    }

    public void setVersion(SMPPVersion version) {
        this.version = version;
    }

    public boolean equals(Object obj) {
        boolean equals = super.equals(obj);
        if (equals) {
            Bind other = (Bind)obj;
            equals |= this.safeCompare(this.systemId, other.systemId);
            equals |= this.safeCompare(this.password, other.password);
            equals |= this.safeCompare(this.systemType, other.systemType);
            equals |= this.safeCompare(this.version, other.version);
            equals |= this.addressTon == other.addressTon;
            equals |= this.addressNpi == other.addressNpi;
            equals |= this.safeCompare(this.addressRange, other.addressRange);
        }
        return equals;
    }

    public int hashCode() {
        int hc1 = this.systemId != null ? this.systemId.hashCode() : 13;
        int hc2 = this.password != null ? this.password.hashCode() : 23;
        int hc3 = this.systemType != null ? this.systemType.hashCode() : 31;
        int hc4 = this.version != null ? this.version.hashCode() : 37;
        int hc5 = Integer.valueOf(this.addressTon).hashCode();
        int hc6 = Integer.valueOf(this.addressNpi).hashCode();
        int hc7 = this.addressRange != null ? this.addressRange.hashCode() : 41;
        int hc8 = super.hashCode();
        return hc1 + hc2 + hc3 + hc4 + hc5 + hc6 + hc7 + hc8;
    }

    protected void toString(StringBuffer buffer) {
        buffer.append("systemId=").append(this.systemId).append(",password=").append(this.password).append(",systemType=").append(this.systemType).append(",version=").append(this.version.getVersionID()).append(",ton=").append(this.addressTon).append(",npi=").append(this.addressNpi).append(",range=").append(this.addressRange);
    }

    protected void validateMandatory(SMPPVersion smppVersion) {
        smppVersion.validateSystemId(this.systemId);
        smppVersion.validatePassword(this.password);
        smppVersion.validateSystemType(this.systemType);
        smppVersion.validateTon(this.addressTon);
        smppVersion.validateNpi(this.addressNpi);
        smppVersion.validateAddressRange(this.addressRange);
    }

    protected void readMandatory(PacketDecoder decoder) {
        this.systemId = decoder.readCString();
        this.password = decoder.readCString();
        this.systemType = decoder.readCString();
        this.version = VersionFactory.getVersion(decoder.readUInt1());
        this.addressTon = decoder.readUInt1();
        this.addressNpi = decoder.readUInt1();
        this.addressRange = decoder.readCString();
    }

    protected void writeMandatory(PacketEncoder encoder) throws IOException {
        encoder.writeCString(this.systemId);
        encoder.writeCString(this.password);
        encoder.writeCString(this.systemType);
        encoder.writeUInt1(this.version.getVersionID());
        encoder.writeUInt1(this.addressTon);
        encoder.writeUInt1(this.addressNpi);
        encoder.writeCString(this.addressRange);
    }

    protected int getMandatorySize() {
        int length = 7;
        length += this.sizeOf(this.systemId);
        length += this.sizeOf(this.password);
        length += this.sizeOf(this.systemType);
        return length += this.sizeOf(this.addressRange);
    }
}

