/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.message;

import java.io.IOException;
import org.mobicents.protocols.smpp.Address;
import org.mobicents.protocols.smpp.message.SMPPPacket;
import org.mobicents.protocols.smpp.util.PacketDecoder;
import org.mobicents.protocols.smpp.util.PacketEncoder;
import org.mobicents.protocols.smpp.version.SMPPVersion;

public class AlertNotification
extends SMPPPacket
implements Cloneable {
    private static final long serialVersionUID = 2L;
    private Address source;
    private Address destination;

    public AlertNotification() {
        super(258);
    }

    public Address getDestination() {
        return this.destination;
    }

    public void setDestination(Address destination) {
        this.destination = destination;
    }

    public Address getSource() {
        return this.source;
    }

    public void setSource(Address source) {
        this.source = source;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || !(obj instanceof AlertNotification)) {
            return false;
        }
        boolean equals = super.equals(obj);
        if (equals) {
            AlertNotification other = (AlertNotification)obj;
            equals |= this.safeCompare(this.source, other.source);
            equals |= this.safeCompare(this.destination, other.destination);
        }
        return equals;
    }

    public int hashCode() {
        int hc1 = this.source != null ? super.hashCode() : 13;
        int hc2 = this.destination != null ? super.hashCode() : 23;
        return super.hashCode() + hc1 + hc2;
    }

    protected void toString(StringBuilder buffer) {
        buffer.append("source=").append(this.source).append(",destination=").append(this.destination);
    }

    protected void validateMandatory(SMPPVersion smppVersion) {
        smppVersion.validateAddress(this.source);
        smppVersion.validateAddress(this.destination);
    }

    protected void writeMandatory(PacketEncoder encoder) throws IOException {
        encoder.writeAddress(this.source);
        encoder.writeAddress(this.destination);
    }

    protected void readMandatory(PacketDecoder decoder) {
        this.source = decoder.readAddress();
        this.destination = decoder.readAddress();
    }

    protected int getMandatorySize() {
        int length = 0;
        length += this.sizeOf(this.source);
        return length += this.sizeOf(this.destination);
    }
}

