/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.gsm.ems;

import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import org.mobicents.protocols.smpp.gsm.AbstractHeaderElement;
import org.mobicents.protocols.smpp.util.ImageUtils;

public abstract class Picture
extends AbstractHeaderElement {
    private int iei;
    private int position;
    private byte[] data;

    public Picture(int iei, BufferedImage image) {
        this.checkImage(image);
        this.iei = iei;
        this.data = this.createData(image);
    }

    public Picture(int iei, BufferedImage image, int position) {
        this(iei, image);
        this.position = position;
    }

    public int getLength() {
        return this.data.length;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public byte[] getData() {
        return this.data;
    }

    protected boolean doWrite(int segmentNum, ByteBuffer buffer) {
        buffer.put((byte)this.iei);
        buffer.put((byte)this.data.length);
        buffer.put(this.data);
        return true;
    }

    protected abstract void checkImage(BufferedImage var1);

    protected int getExtraHeaderSize() {
        return 0;
    }

    protected void writeHeader(BufferedImage image, ByteBuffer buffer) {
    }

    private byte[] createData(BufferedImage image) {
        int size;
        int headerSize = 1 + this.getExtraHeaderSize();
        int width = image.getWidth();
        int height = image.getHeight();
        int bytesWidth = width / 8 + 1;
        if (width % 8 == 0) {
            --bytesWidth;
        }
        if ((size = headerSize + bytesWidth * height) > 137 - this.getExtraHeaderSize()) {
            throw new IllegalStateException("Picture is too big.");
        }
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.put((byte)this.position);
        this.writeHeader(image, buffer);
        ImageUtils.imageToBwBitmap(image, buffer);
        return buffer.array();
    }
}

