/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.gsm.ems;

import java.nio.ByteBuffer;
import org.mobicents.protocols.smpp.gsm.AbstractHeaderElement;

public class ExtendedObject
extends AbstractHeaderElement {
    private int referenceNum;
    private int objectFormat;
    private int objectPosition;
    private int ptr;
    private byte[] data = new byte[0];
    private boolean mayForward = true;
    private boolean userPrompt;

    public ExtendedObject(int objectFormat, int referenceNum) {
        this.objectFormat = objectFormat;
        this.referenceNum = referenceNum;
    }

    public ExtendedObject(int objectFormat, int referenceNum, byte[] data) {
        this(objectFormat, referenceNum);
        this.setData(data);
    }

    public int getLength() {
        return this.data.length;
    }

    public void reset() {
        super.reset();
        this.ptr = 0;
    }

    public boolean isComplete() {
        return this.ptr == this.data.length;
    }

    public boolean write(int segmentNum, ByteBuffer buffer) {
        if (this.ptr == 0 && buffer.remaining() < 9) {
            return false;
        }
        if (this.ptr > 0 && buffer.remaining() < 3) {
            return false;
        }
        int dataSize = Math.min(buffer.remaining() - 2, this.data.length - this.ptr);
        buffer.put((byte)20);
        buffer.put((byte)dataSize);
        buffer.put(this.data, this.ptr, dataSize);
        this.ptr += dataSize;
        return true;
    }

    public boolean isMayForward() {
        return this.mayForward;
    }

    public void setMayForward(boolean mayForward) {
        this.mayForward = mayForward;
    }

    public boolean isUserPrompt() {
        return this.userPrompt;
    }

    public void setUserPrompt(boolean userPrompt) {
        this.userPrompt = userPrompt;
    }

    public int getObjectFormat() {
        return this.objectFormat;
    }

    public int getObjectPosition() {
        return this.objectPosition;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        if (data == null) {
            throw new NullPointerException("data cannot be null");
        }
        this.data = new byte[data.length + 7];
        System.arraycopy(data, 0, this.data, 7, data.length);
        this.initHeader(data.length);
        this.reset();
    }

    public void setObjectPosition(int objectPosition) {
        this.objectPosition = objectPosition;
    }

    private int getControlData() {
        int control = 0;
        if (!this.mayForward) {
            control |= 1;
        }
        if (this.userPrompt) {
            control |= 2;
        }
        return control;
    }

    private void initHeader(int dataLength) {
        this.data[0] = (byte)this.referenceNum;
        this.data[1] = (byte)(dataLength >> 8);
        this.data[2] = (byte)(dataLength & 0xFF);
        this.data[3] = (byte)this.getControlData();
        this.data[4] = (byte)this.objectFormat;
        this.data[5] = (byte)(this.objectPosition >> 8);
        this.data[6] = (byte)(this.objectPosition & 0xFF);
    }
}

