/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.gsm.ems;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.mobicents.protocols.smpp.gsm.AbstractHeaderElement;
import org.mobicents.protocols.smpp.gsm.ems.ExtendedObject;

public class CompressedData
extends AbstractHeaderElement {
    private List<ExtendedObject> objects = new ArrayList<ExtendedObject>();
    private byte[] compressedData;
    private int ptr;

    public void add(ExtendedObject object) {
        this.objects.add(object);
    }

    public byte[] compress() {
        int length = 0;
        for (ExtendedObject obj : this.objects) {
            length += obj.getLength();
        }
        ByteBuffer buffer = ByteBuffer.allocate(length += this.objects.size());
        for (ExtendedObject obj : this.objects) {
            buffer.put((byte)20);
            buffer.put(obj.getData());
        }
        byte[] uncompressed = buffer.array();
        ByteBuffer compressed = ByteBuffer.allocate(length);
        ByteBuffer literal = ByteBuffer.allocate(length);
        literal.put(uncompressed, 0, 2);
        int readPos = 2;
        while (readPos < length) {
            int sliceSize;
            boolean sliceFound = false;
            int slicePos = -1;
            for (sliceSize = Math.min(Math.min(63, readPos), uncompressed.length - readPos); sliceSize > 2; --sliceSize) {
                slicePos = this.findSlice(uncompressed, readPos, sliceSize);
                if (slicePos < 0) continue;
                sliceFound = true;
                break;
            }
            if (!sliceFound) {
                literal.put(uncompressed[readPos]);
                ++readPos;
                continue;
            }
            this.outputLiterals(compressed, literal);
            slicePos = readPos - slicePos;
            int descriptor = (sliceSize & 0x2F) << 9 | slicePos & 0x1FF;
            compressed.putShort((short)descriptor);
            readPos += sliceSize;
        }
        compressed.flip();
        this.compressedData = new byte[compressed.remaining()];
        compressed.get(this.compressedData, 0, compressed.remaining());
        return this.compressedData;
    }

    public void reset() {
        super.reset();
        this.objects.clear();
        this.compressedData = null;
        this.ptr = 0;
    }

    public int getLength() {
        if (this.compressedData == null) {
            throw new IllegalStateException("Must compress the data first.");
        }
        return this.compressedData.length + 3;
    }

    public boolean isComplete() {
        if (this.compressedData == null) {
            throw new IllegalStateException("Must compress the data first.");
        }
        return this.ptr == this.compressedData.length;
    }

    public boolean write(int segmentNum, ByteBuffer buffer) {
        int dataSize;
        int headerSize;
        boolean writeHeader;
        if (this.compressedData == null) {
            throw new IllegalStateException("Must compress the data first.");
        }
        boolean bl = writeHeader = this.ptr == 0;
        if (writeHeader && buffer.remaining() < 5) {
            return false;
        }
        if (!writeHeader && buffer.remaining() < 3) {
            return false;
        }
        if (writeHeader) {
            headerSize = 3;
            dataSize = Math.min(buffer.remaining() - 5, this.compressedData.length - this.ptr);
        } else {
            headerSize = 0;
            dataSize = Math.min(buffer.remaining() - 2, this.compressedData.length - this.ptr);
        }
        buffer.put((byte)22);
        buffer.put((byte)(headerSize + dataSize));
        if (writeHeader) {
            buffer.put((byte)0);
            buffer.putShort((short)this.compressedData.length);
        }
        buffer.put(this.compressedData, this.ptr, dataSize);
        this.ptr += dataSize;
        return true;
    }

    private int findSlice(byte[] data, int readPos, int sliceSize) {
        int endPos = Math.max(readPos - 511, 0);
        for (int pos = readPos - sliceSize; pos >= endPos; --pos) {
            boolean matched = true;
            for (int i = 0; i < sliceSize; ++i) {
                if (data[readPos + i] == data[pos + i]) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            return pos;
        }
        return -1;
    }

    private void outputLiterals(ByteBuffer compressed, ByteBuffer literal) {
        literal.flip();
        while (literal.remaining() > 0) {
            int size = Math.min(127, literal.remaining());
            compressed.put((byte)(0x80 | size));
            for (int i = 0; i < size; ++i) {
                compressed.put(literal.get());
            }
        }
        literal.clear();
    }
}

