/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.gsm;

import java.util.ArrayList;
import org.mobicents.protocols.smpp.Address;
import org.mobicents.protocols.smpp.message.DataSM;
import org.mobicents.protocols.smpp.message.DeliverSM;
import org.mobicents.protocols.smpp.message.SubmitSM;
import org.mobicents.protocols.smpp.message.tlv.Tag;

public final class UserDataUtil {
    private UserDataUtil() {
    }

    public static SubmitSM[] createSubmits(byte[][] segments, Address from, Address to) {
        ArrayList packets = new ArrayList();
        for (byte[] segment : segments) {
            SubmitSM p = new SubmitSM();
            p.setSource(from);
            p.setDestination(to);
            p.setEsmClass(64);
            p.setMessage(segment);
        }
        return packets.toArray(new SubmitSM[packets.size()]);
    }

    public static DeliverSM[] createDelivers(byte[][] segments, Address from, Address to) {
        ArrayList packets = new ArrayList();
        for (byte[] segment : segments) {
            DeliverSM p = new DeliverSM();
            p.setSource(from);
            p.setDestination(to);
            p.setEsmClass(64);
            p.setMessage(segment);
        }
        return packets.toArray(new DeliverSM[packets.size()]);
    }

    public static DataSM[] createDataSM(byte[][] segments, Address from, Address to) {
        ArrayList packets = new ArrayList();
        for (byte[] segment : segments) {
            DataSM p = new DataSM();
            p.setSource(from);
            p.setDestination(to);
            p.setEsmClass(64);
            p.setTLV(Tag.MESSAGE_PAYLOAD, segment);
        }
        return packets.toArray(new DataSM[packets.size()]);
    }
}

