/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.gsm;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.mobicents.protocols.smpp.gsm.ConcatenatedSms;
import org.mobicents.protocols.smpp.gsm.HeaderElement;
import org.mobicents.protocols.smpp.gsm.HeaderElementComparator;
import org.mobicents.protocols.smpp.gsm.UserData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserDataImpl
implements UserData {
    private LinkedList<HeaderElement> headerElements = new LinkedList();
    private byte[] data;
    private boolean useConcat16;

    public UserDataImpl() {
    }

    public UserDataImpl(boolean useConcat16) {
        this.useConcat16 = useConcat16;
    }

    @Override
    public void addHeaderElement(HeaderElement element) {
        if (element instanceof ConcatenatedSms) {
            throw new IllegalArgumentException("Concatenated SMS is handled automatically.");
        }
        this.headerElements.add(element);
        Collections.sort(this.headerElements, new HeaderElementComparator());
    }

    @Override
    public byte[] toSingleSms() {
        byte[][] segments = this.toSegments();
        if (segments.length > 1) {
            throw new IllegalStateException("There is more than one message segment");
        }
        return segments[0];
    }

    @Override
    public byte[][] toSegments() {
        List<HeaderElement> elements;
        ArrayList<ByteBuffer> segments = new ArrayList<ByteBuffer>();
        if (this.calcSize(this.headerElements, this.data) > 140) {
            elements = this.dupElements();
            ConcatenatedSms concat = new ConcatenatedSms(this.useConcat16);
            elements.add(0, concat);
        } else {
            elements = this.headerElements;
        }
        ByteBuffer dataBuffer = this.data != null ? ByteBuffer.wrap(this.data) : ByteBuffer.wrap(new byte[0]);
        boolean needMoreSegments = true;
        boolean needUdhl = elements.size() > 0;
        int segmentNum = 0;
        while (needMoreSegments) {
            ++segmentNum;
            ByteBuffer segment = ByteBuffer.allocate(140);
            if (needUdhl) {
                segment.put((byte)0);
            }
            boolean allComplete = true;
            for (HeaderElement element : elements) {
                if (element.isRecurring() || !element.isComplete()) {
                    element.write(segmentNum, segment);
                }
                allComplete &= element.isComplete();
                if (segment.remaining() >= 2) continue;
                break;
            }
            int headerSize = segment.capacity() - segment.remaining() - 1;
            segment.put(0, (byte)headerSize);
            if (segment.remaining() > 0) {
                int numBytes = Math.min(segment.remaining(), dataBuffer.remaining());
                dataBuffer.get(segment.array(), segment.position(), numBytes);
                segment.position(segment.position() + numBytes);
            }
            segments.add(segment);
            if (!allComplete || dataBuffer.remaining() != 0) continue;
            needMoreSegments = false;
        }
        for (HeaderElement element : elements) {
            element.postProcess(segments);
        }
        byte[][] result = new byte[segments.size()][];
        for (int i = 0; i < segments.size(); ++i) {
            ByteBuffer segment = (ByteBuffer)segments.get(i);
            if (segment.remaining() == 0) {
                result[i] = segment.array();
                continue;
            }
            segment.flip();
            result[i] = new byte[segment.remaining()];
            segment.get(result[i], 0, result[i].length);
        }
        return result;
    }

    @Override
    public boolean isMultiMessage() {
        return this.calcSize(this.headerElements, this.data) > 140;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public void setData(byte[] data) {
        this.data = data;
    }

    private int calcSize(List<HeaderElement> elements, byte[] data) {
        int size = 0;
        if (elements.size() > 0) {
            ++size;
        }
        if (data != null) {
            size += data.length;
        }
        for (HeaderElement element : elements) {
            size += element.getLength() + 2;
        }
        return size;
    }

    private List<HeaderElement> dupElements() {
        return new LinkedList<HeaderElement>(this.headerElements);
    }
}

