/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.gsm;

import java.nio.ByteBuffer;
import org.mobicents.protocols.smpp.gsm.RecurringHeaderElement;

public class PortAddressing8
extends RecurringHeaderElement {
    private int sourcePort;
    private int destPort;

    public PortAddressing8() {
        super(true);
    }

    public PortAddressing8(int sourcePort, int destPort) {
        super(true);
        this.setSourcePort(sourcePort);
        this.setDestPort(destPort);
    }

    public int getLength() {
        return 2;
    }

    public boolean write(int segmentNum, ByteBuffer buffer) {
        buffer.put((byte)4);
        buffer.put((byte)2);
        buffer.put((byte)this.destPort);
        buffer.put((byte)this.sourcePort);
        return true;
    }

    public int getSourcePort() {
        return this.sourcePort;
    }

    public void setSourcePort(int sourcePort) {
        if (sourcePort < 0 || sourcePort > 255) {
            throw new IllegalArgumentException("Source port must be 0 <= port <= 0xff");
        }
        this.sourcePort = sourcePort;
    }

    public int getDestPort() {
        return this.destPort;
    }

    public void setDestPort(int destPort) {
        if (destPort < 0 || destPort > 255) {
            throw new IllegalArgumentException("Destination port must be 0 <= port <= 0xff");
        }
        this.destPort = destPort;
    }
}

