/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.gsm;

import java.nio.ByteBuffer;
import org.mobicents.protocols.smpp.gsm.RecurringHeaderElement;

public class PortAddressing16
extends RecurringHeaderElement {
    private int sourcePort;
    private int destPort;

    public PortAddressing16() {
        super(true);
    }

    public PortAddressing16(int sourcePort, int destPort) {
        super(true);
        this.setSourcePort(sourcePort);
        this.setDestPort(destPort);
    }

    public int getLength() {
        return 4;
    }

    public boolean doWrite(int segmentNum, ByteBuffer buffer) {
        buffer.put((byte)5);
        buffer.put((byte)4);
        buffer.putShort((short)this.destPort);
        buffer.putShort((short)this.sourcePort);
        return true;
    }

    public int getSourcePort() {
        return this.sourcePort;
    }

    public void setSourcePort(int sourcePort) {
        if (sourcePort < 0 || sourcePort > 65535) {
            throw new IllegalArgumentException("Source port must be 0 <= port <= 0xffff");
        }
        this.sourcePort = sourcePort;
    }

    public int getDestPort() {
        return this.destPort;
    }

    public void setDestPort(int destPort) {
        if (destPort < 0 || destPort > 65535) {
            throw new IllegalArgumentException("Destination port must be 0 <= port <= 0xffff");
        }
        this.destPort = destPort;
    }
}

