/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.gsm;

import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.mobicents.protocols.smpp.gsm.RecurringHeaderElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcatenatedSms
extends RecurringHeaderElement {
    private static final Random RANDOM = new SecureRandom();
    private int referenceNumber = 1;
    private boolean use16bitRef;
    private Map<ByteBuffer, Integer> totalMsgs = new HashMap<ByteBuffer, Integer>();

    public ConcatenatedSms(boolean use16bitRef) {
        super(true);
        this.use16bitRef = use16bitRef;
        this.reset();
    }

    @Override
    public boolean doWrite(int segmentNum, ByteBuffer buffer) {
        if (this.use16bitRef) {
            buffer.put((byte)8);
            buffer.put((byte)4);
            buffer.putShort((short)this.referenceNumber);
        } else {
            buffer.put((byte)0);
            buffer.put((byte)3);
            buffer.put((byte)this.referenceNumber);
        }
        this.totalMsgs.put(buffer, buffer.position());
        buffer.put((byte)1);
        buffer.put((byte)segmentNum);
        return true;
    }

    @Override
    public int getLength() {
        if (this.use16bitRef) {
            return 4;
        }
        return 3;
    }

    @Override
    public void reset() {
        super.reset();
        int max = this.use16bitRef ? 65535 : 255;
        this.referenceNumber = RANDOM.nextInt(max);
    }

    @Override
    public void postProcess(List<ByteBuffer> segments) {
        int numSegments = segments.size();
        if (numSegments != this.totalMsgs.size()) {
            throw new IllegalStateException("Cannot update all segments");
        }
        for (Map.Entry<ByteBuffer, Integer> entry : this.totalMsgs.entrySet()) {
            entry.getKey().put((int)entry.getValue(), (byte)numSegments);
        }
    }
}

