/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.event;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.mobicents.protocols.smpp.Session;
import org.mobicents.protocols.smpp.event.AbstractEventDispatcher;
import org.mobicents.protocols.smpp.event.SMPPEvent;
import org.mobicents.protocols.smpp.event.SessionObserver;
import org.mobicents.protocols.smpp.message.SMPPPacket;
import org.mobicents.protocols.smpp.util.APIConfig;
import org.mobicents.protocols.smpp.util.APIConfigFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskExecutorEventDispatcher
extends AbstractEventDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(TaskExecutorEventDispatcher.class);
    private Executor executor;
    private int threadCount = 0;

    public void destroy() {
        if (this.executor instanceof ExecutorService) {
            ((ExecutorService)this.executor).shutdownNow();
        }
    }

    public void init() {
        if (this.executor == null) {
            int numThreads = this.threadCount;
            if (numThreads < 1) {
                numThreads = this.getNumThreadsFromConfig();
            }
            this.executor = Executors.newFixedThreadPool(numThreads);
        }
    }

    public void notifyObservers(final Session conn, final SMPPEvent event) {
        final SessionObserver[] observers = this.getObserverList();
        this.executor.execute(new Runnable(){

            public void run() {
                TaskExecutorEventDispatcher.this.doUpdate(observers, conn, event);
            }
        });
    }

    public void notifyObservers(final Session conn, final SMPPPacket packet) {
        final SessionObserver[] observers = this.getObserverList();
        this.executor.execute(new Runnable(){

            public void run() {
                TaskExecutorEventDispatcher.this.doPacketReceived(observers, conn, packet);
            }
        });
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    private void doUpdate(SessionObserver[] observers, Session session, SMPPEvent event) {
        for (SessionObserver observer : observers) {
            try {
                observer.update(session, event);
            }
            catch (Throwable t) {
                LOG.error("Observer " + observer + " threw an exception", t);
            }
        }
    }

    private void doPacketReceived(SessionObserver[] observers, Session session, SMPPPacket packet) {
        for (SessionObserver observer : observers) {
            try {
                observer.packetReceived(session, packet);
            }
            catch (Throwable t) {
                LOG.error("Observer " + observer + " threw an exception", t);
            }
        }
    }

    private int getNumThreadsFromConfig() {
        APIConfig config = APIConfigFactory.getConfig();
        return config.getInt("smppapi.event.threaded_dispatcher.pool_size", 3);
    }
}

