/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.event;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.mobicents.protocols.smpp.SMPPRuntimeException;
import org.mobicents.protocols.smpp.Session;
import org.mobicents.protocols.smpp.event.ReceiverExceptionEvent;
import org.mobicents.protocols.smpp.event.ReceiverExitEvent;
import org.mobicents.protocols.smpp.event.ReceiverStartEvent;
import org.mobicents.protocols.smpp.event.SMPPEvent;
import org.mobicents.protocols.smpp.event.SessionObserver;
import org.mobicents.protocols.smpp.message.BindResp;
import org.mobicents.protocols.smpp.message.CancelSMResp;
import org.mobicents.protocols.smpp.message.DeliverSM;
import org.mobicents.protocols.smpp.message.EnquireLink;
import org.mobicents.protocols.smpp.message.EnquireLinkResp;
import org.mobicents.protocols.smpp.message.GenericNack;
import org.mobicents.protocols.smpp.message.ParamRetrieveResp;
import org.mobicents.protocols.smpp.message.QueryLastMsgsResp;
import org.mobicents.protocols.smpp.message.QueryMsgDetailsResp;
import org.mobicents.protocols.smpp.message.QuerySMResp;
import org.mobicents.protocols.smpp.message.ReplaceSMResp;
import org.mobicents.protocols.smpp.message.SMPPPacket;
import org.mobicents.protocols.smpp.message.SubmitMultiResp;
import org.mobicents.protocols.smpp.message.SubmitSMResp;
import org.mobicents.protocols.smpp.message.Unbind;
import org.mobicents.protocols.smpp.message.UnbindResp;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SMPPEventAdapter
implements SessionObserver {
    private static final Map<Class<? extends SMPPPacket>, Method> HANDLERS = new HashMap<Class<? extends SMPPPacket>, Method>();

    @Override
    public final void update(Session source, SMPPEvent event) {
        try {
            switch (event.getType()) {
                case 2: {
                    this.receiverStart(source, (ReceiverStartEvent)event);
                    break;
                }
                case 3: {
                    ReceiverExitEvent ree = (ReceiverExitEvent)event;
                    if (ree.getReason() == 2) {
                        this.receiverExitException(source, ree);
                        break;
                    }
                    this.receiverExit(source, ree);
                    break;
                }
                case 4: {
                    this.receiverException(source, (ReceiverExceptionEvent)event);
                    break;
                }
                default: {
                    this.userEvent(source, event);
                    break;
                }
            }
        }
        catch (ClassCastException x) {
            LoggerFactory.getLogger(SMPPEventAdapter.class).error("Class cast exception", (Throwable)x);
        }
    }

    @Override
    public final void packetReceived(Session source, SMPPPacket pak) {
        try {
            Method handler = HANDLERS.get(pak.getClass());
            if (handler != null) {
                Object[] args = new Object[]{source, pak};
                handler.invoke((Object)this, args);
            } else {
                this.unidentified(source, pak);
            }
        }
        catch (Exception e) {
            throw new SMPPRuntimeException("Exception calling packet handler", e);
        }
    }

    public void receiverExit(Session source, ReceiverExitEvent rev) {
    }

    public void receiverExitException(Session source, ReceiverExitEvent rev) {
    }

    public void receiverException(Session source, ReceiverExceptionEvent rev) {
    }

    public void receiverStart(Session source, ReceiverStartEvent rs) {
    }

    public void userEvent(Session source, SMPPEvent ev) {
    }

    public void deliverSM(Session source, DeliverSM dm) {
    }

    public void submitSMResponse(Session source, SubmitSMResp smr) {
    }

    public void submitMultiResponse(Session source, SubmitMultiResp smr) {
    }

    public void cancelSMResponse(Session source, CancelSMResp cmr) {
    }

    public void replaceSMResponse(Session source, ReplaceSMResp rmr) {
    }

    public void paramRetrieveResponse(Session source, ParamRetrieveResp prr) {
    }

    public void queryResponse(Session source, SMPPPacket qr) {
    }

    public void queryLink(Session source, EnquireLink el) {
    }

    public void queryLinkResponse(Session source, EnquireLinkResp elr) {
    }

    public void unbind(Session source, Unbind ubd) {
    }

    public void unbindResponse(Session source, UnbindResp ubr) {
    }

    public void bindResponse(Session source, BindResp br) {
    }

    public void genericNack(Session source, GenericNack nack) {
    }

    public void unidentified(Session source, SMPPPacket pak) {
    }

    private static void initHandlers() {
        try {
            SMPPEventAdapter.addHandler(DeliverSM.class, "deliverSM");
            SMPPEventAdapter.addHandler(SubmitSMResp.class, "submitSMResponse");
            SMPPEventAdapter.addHandler(SubmitMultiResp.class, "submitMultiResponse");
            SMPPEventAdapter.addHandler(CancelSMResp.class, "cancelSMResponse");
            SMPPEventAdapter.addHandler(ReplaceSMResp.class, "replaceSMResponse");
            SMPPEventAdapter.addHandler(ParamRetrieveResp.class, "paramRetrieveResponse");
            SMPPEventAdapter.addHandler(QuerySMResp.class, SMPPPacket.class, "queryResponse");
            SMPPEventAdapter.addHandler(QueryLastMsgsResp.class, SMPPPacket.class, "queryResponse");
            SMPPEventAdapter.addHandler(QueryMsgDetailsResp.class, SMPPPacket.class, "queryResponse");
            SMPPEventAdapter.addHandler(EnquireLink.class, "queryLink");
            SMPPEventAdapter.addHandler(EnquireLinkResp.class, "queryLinkResponse");
            SMPPEventAdapter.addHandler(Unbind.class, "unbind");
            SMPPEventAdapter.addHandler(UnbindResp.class, "unbindResponse");
            SMPPEventAdapter.addHandler(BindResp.class, "bindResponse");
            SMPPEventAdapter.addHandler(GenericNack.class, "genericNack");
        }
        catch (NoSuchMethodException x) {
            throw new RuntimeException("Illegal handler mapping", x);
        }
    }

    private static void addHandler(Class<? extends SMPPPacket> clazz, String methodName) throws NoSuchMethodException {
        HANDLERS.put(clazz, SMPPEventAdapter.getMethod(methodName, clazz));
    }

    private static void addHandler(Class<? extends SMPPPacket> clazz, Class<? extends SMPPPacket> argClass, String methodName) throws NoSuchMethodException {
        HANDLERS.put(clazz, SMPPEventAdapter.getMethod(methodName, argClass));
    }

    private static Method getMethod(String name, Class<?> argClass) throws NoSuchMethodException {
        Class[] args = new Class[]{Session.class, argClass};
        return SMPPEventAdapter.class.getMethod(name, args);
    }

    static {
        SMPPEventAdapter.initHandlers();
    }
}

