/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.mobicents.protocols.smpp.event.EventDispatcher;
import org.mobicents.protocols.smpp.event.SessionObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEventDispatcher
implements EventDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEventDispatcher.class);
    private List<SessionObserver> observers = new ArrayList<SessionObserver>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addObserver(SessionObserver observer) {
        List<SessionObserver> list = this.observers;
        synchronized (list) {
            if (!this.observers.contains(observer)) {
                this.observers.add(observer);
            } else {
                LOG.info("Not adding observer because it's already registered");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeObserver(SessionObserver observer) {
        List<SessionObserver> list = this.observers;
        synchronized (list) {
            this.observers.remove(observer);
        }
    }

    @Override
    public Collection<SessionObserver> getObservers() {
        return Collections.unmodifiableCollection(this.observers);
    }

    @Override
    public Iterator<SessionObserver> observerIterator() {
        return Collections.unmodifiableList(this.observers).iterator();
    }

    public boolean contains(SessionObserver observer) {
        return this.observers.contains(observer);
    }

    public int size() {
        return this.observers.size();
    }

    protected SessionObserver[] getObserverList() {
        SessionObserver[] observerList = this.observers.toArray(new SessionObserver[0]);
        return observerList;
    }
}

