/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.encoding;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.mobicents.protocols.smpp.SMPPRuntimeException;
import org.mobicents.protocols.smpp.encoding.ASCIIEncoding;
import org.mobicents.protocols.smpp.encoding.AlphabetEncoding;
import org.mobicents.protocols.smpp.encoding.BinaryEncoding;
import org.mobicents.protocols.smpp.encoding.DefaultAlphabetEncoding;
import org.mobicents.protocols.smpp.encoding.Latin1Encoding;
import org.mobicents.protocols.smpp.encoding.MessageEncoding;
import org.mobicents.protocols.smpp.encoding.UCS2Encoding;
import org.mobicents.protocols.smpp.util.APIConfig;
import org.mobicents.protocols.smpp.util.APIConfigFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncodingFactory {
    static final String DEFAULT_ALPHABET_PROPNAME = "smpp.default_alphabet";
    private static final Logger LOG = LoggerFactory.getLogger(EncodingFactory.class);
    private static final EncodingFactory INSTANCE = new EncodingFactory();
    private final Map<Integer, MessageEncoding<?>> mappingTable = new HashMap();
    private final Map<String, AlphabetEncoding> langToAlphabet = new HashMap<String, AlphabetEncoding>();
    private AlphabetEncoding defaultAlphabet;

    public EncodingFactory() {
        this.addEncoding(new BinaryEncoding());
        DefaultAlphabetEncoding gsmDefault = new DefaultAlphabetEncoding();
        this.addEncoding(gsmDefault);
        this.langToAlphabet.put("en", gsmDefault);
        this.langToAlphabet.put("de", gsmDefault);
        this.langToAlphabet.put("fr", gsmDefault);
        this.langToAlphabet.put("it", gsmDefault);
        this.langToAlphabet.put("nl", gsmDefault);
        this.langToAlphabet.put("es", gsmDefault);
        try {
            ASCIIEncoding ascii = new ASCIIEncoding();
            this.addEncoding(ascii);
            this.langToAlphabet.put(null, ascii);
        }
        catch (UnsupportedEncodingException x) {
            LOG.debug("UCS2 encoding is not supported.");
        }
        try {
            Latin1Encoding latin1 = new Latin1Encoding();
            this.addEncoding(latin1);
            this.langToAlphabet.put(null, latin1);
        }
        catch (UnsupportedEncodingException x) {
            LOG.debug("UCS2 encoding is not supported.");
        }
        try {
            UCS2Encoding ucs2 = new UCS2Encoding();
            this.addEncoding(ucs2);
            this.langToAlphabet.put(null, ucs2);
        }
        catch (UnsupportedEncodingException x) {
            LOG.debug("UCS2 encoding is not supported.");
        }
        LOG.debug("Using {} as the catch-all language alphabet.", (Object)this.langToAlphabet.get(null).getClass().getSimpleName());
        this.initDefaultAlphabet();
    }

    public static final EncodingFactory getInstance() {
        return INSTANCE;
    }

    public MessageEncoding<?> getEncoding(int dataCoding) {
        return this.mappingTable.get(dataCoding);
    }

    public void addEncoding(MessageEncoding<?> encoding) {
        this.mappingTable.put(encoding.getDataCoding(), encoding);
    }

    public void addEncoding(Class<? extends MessageEncoding<?>> encodingClass) {
        this.addEncoding(this.instantiateEncoding(encodingClass));
    }

    public Iterator<MessageEncoding<?>> getAllEncodings() {
        return this.mappingTable.values().iterator();
    }

    public AlphabetEncoding getDefaultAlphabet() {
        return this.defaultAlphabet;
    }

    public AlphabetEncoding getAlphabet(String lang) {
        AlphabetEncoding enc = this.langToAlphabet.get(lang);
        if (enc != null) {
            return enc;
        }
        return this.langToAlphabet.get(null);
    }

    private void initDefaultAlphabet() {
        String className = "";
        try {
            className = System.getProperty(DEFAULT_ALPHABET_PROPNAME);
            if (className != null) {
                Class<?> alphaClass = Class.forName(className);
                this.defaultAlphabet = this.instantiateEncoding(alphaClass);
            } else {
                APIConfig cfg = APIConfigFactory.getConfig();
                this.defaultAlphabet = cfg.getClassInstance("smppapi.default_alphabet", AlphabetEncoding.class, null);
            }
        }
        catch (Exception x) {
            LOG.warn("Couldn't load default alphabet {}: {}", (Object)className, (Object)x.getMessage());
        }
        if (this.defaultAlphabet == null) {
            this.defaultAlphabet = new DefaultAlphabetEncoding();
        }
    }

    private AlphabetEncoding instantiateEncoding(Class<?> encodingClass) {
        try {
            return (AlphabetEncoding)encodingClass.newInstance();
        }
        catch (Exception x) {
            LOG.error("Could not instantiate a {}: {}", encodingClass, (Object)x);
            throw new SMPPRuntimeException(x);
        }
    }
}

