/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.encoding;

import java.io.ByteArrayOutputStream;
import org.mobicents.protocols.smpp.encoding.AlphabetEncoding;

public class DefaultAlphabetEncoding
extends AlphabetEncoding {
    private static final int DCS = 0;
    public static final int EXTENDED_ESCAPE = 27;
    public static final int PAGE_BREAK = 10;
    protected final char[] CHAR_TABLE = new char[]{'@', '\u00a3', '$', '\u00a5', '\u00e8', '\u00e9', '\u00f9', '\u00ec', '\u00f2', '\u00c7', '\n', '\u00d8', '\u00f8', '\r', '\u00c5', '\u00e5', '\u0394', '_', '\u03a6', '\u0393', '\u039b', '\u03a9', '\u03a0', '\u03a8', '\u03a3', '\u0398', '\u039e', ' ', '\u00c6', '\u00e6', '\u00df', '\u00c9', ' ', '!', '\"', '#', '\u00a4', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '\u00a1', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c4', '\u00d6', '\u00d1', '\u00dc', '\u00a7', '\u00bf', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00e4', '\u00f6', '\u00f1', '\u00fc', '\u00e0'};
    protected final char[] EXT_CHAR_TABLE = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '^', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '{', '}', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\\', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '[', '~', ']', '\u0000', '|', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u20ac', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};
    private int unknownCharReplacement = 63;

    public DefaultAlphabetEncoding() {
        super(0);
    }

    public void setUnknownCharReplacement(int unknownCharReplacement) {
        if (unknownCharReplacement < 0 || unknownCharReplacement > 127 || unknownCharReplacement == 27) {
            throw new IllegalArgumentException("Illegal replacement code point " + unknownCharReplacement);
        }
        this.unknownCharReplacement = unknownCharReplacement;
    }

    public int getUnknownCharReplacement() {
        return this.unknownCharReplacement;
    }

    public String decode(byte[] data, int offset, int length) {
        if (data == null) {
            throw new NullPointerException("Data cannot be null");
        }
        char[] table = this.CHAR_TABLE;
        StringBuffer buf = new StringBuffer();
        for (int i = offset; i < offset + length; ++i) {
            int code = data[i] & 0xFF;
            if (code == 27) {
                table = this.EXT_CHAR_TABLE;
                continue;
            }
            if (code >= table.length) {
                code = this.unknownCharReplacement;
            }
            buf.append(table[code]);
            table = this.CHAR_TABLE;
        }
        return buf.toString();
    }

    public byte[] encode(String s) {
        if (s == null) {
            return new byte[0];
        }
        char[] c = s.toCharArray();
        ByteArrayOutputStream enc = new ByteArrayOutputStream(256);
        for (int loop = 0; loop < c.length; ++loop) {
            int search;
            for (search = 0; search < this.CHAR_TABLE.length; ++search) {
                if (search == 27) continue;
                if (c[loop] == this.CHAR_TABLE[search]) {
                    enc.write((byte)search);
                    break;
                }
                if (c[loop] != this.EXT_CHAR_TABLE[search]) continue;
                enc.write(27);
                enc.write((byte)search);
                break;
            }
            if (search != this.CHAR_TABLE.length) continue;
            enc.write((byte)this.unknownCharReplacement);
        }
        return enc.toByteArray();
    }

    public int getCharSize() {
        return 7;
    }

    public byte[] pack(byte[] unpacked) {
        int packedLen = unpacked.length - unpacked.length / 8;
        byte[] packed = new byte[packedLen];
        if (unpacked.length == 0) {
            return packed;
        }
        int i = 0;
        int j = -1;
        while (i < packed.length) {
            int shiftRight = i % 7;
            int shiftLeft = 8 - (shiftRight + 1);
            if (shiftRight == 0) {
                ++j;
            }
            int b = (unpacked[j] & 0xFF) >>> shiftRight;
            if (j + 1 < unpacked.length) {
                b |= (unpacked[j + 1] & 0xFF) << shiftLeft;
            }
            packed[i] = (byte)b;
            ++i;
            ++j;
        }
        return packed;
    }

    public byte[] unpack(byte[] packed) {
        int unpackedLen = packed.length * 8 / 7;
        byte[] unpacked = new byte[unpackedLen];
        if (packed.length == 0) {
            return unpacked;
        }
        int i = 0;
        int j = 0;
        while (i < packed.length) {
            int shiftLeft = i % 7;
            int shiftRight = 8 - shiftLeft;
            if (shiftLeft == 0) {
                unpacked[j] = (byte)(packed[i] & 0x7F);
            } else {
                int b = (packed[i - 1] & 0xFF) >>> shiftRight;
                unpacked[j] = (byte)(b |= packed[i] << shiftLeft & 0x7F);
                if (shiftLeft == 6) {
                    unpacked[++j] = (byte)((packed[i] & 0xFF) >>> 1);
                }
            }
            ++i;
            ++j;
        }
        return unpacked;
    }
}

