/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.encoding;

import java.io.UnsupportedEncodingException;
import org.mobicents.protocols.smpp.SMPPRuntimeException;
import org.mobicents.protocols.smpp.encoding.AbstractMessageEncoding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlphabetEncoding
extends AbstractMessageEncoding<String> {
    private String charset;

    protected AlphabetEncoding(int dcs) {
        super(dcs);
    }

    public String getCharset() {
        return this.charset;
    }

    @Override
    public String decode(byte[] data) {
        if (data != null) {
            return this.decode(data, 0, data.length);
        }
        return "";
    }

    public String decode(byte[] data, int offset, int length) {
        try {
            if (data != null) {
                return new String(data, offset, length, this.charset);
            }
            throw new NullPointerException("Data cannot be null");
        }
        catch (UnsupportedEncodingException x) {
            throw new RuntimeException();
        }
    }

    @Override
    public byte[] encode(String string) {
        try {
            if (string != null) {
                return string.getBytes(this.charset);
            }
        }
        catch (UnsupportedEncodingException x) {
            throw new RuntimeException();
        }
        return new byte[0];
    }

    public int getEncodedSize(String string) {
        if (string != null) {
            return this.encode(string).length;
        }
        return 0;
    }

    protected void setCharset(String charset) throws UnsupportedEncodingException {
        if (this.charset != null) {
            throw new SMPPRuntimeException("Cannot change charset.");
        }
        new String("probe").getBytes(charset);
        this.charset = charset;
    }
}

