/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.mobicents.protocols.smpp.IllegalStateException;
import org.mobicents.protocols.smpp.Receiver;
import org.mobicents.protocols.smpp.ReceiverThread;
import org.mobicents.protocols.smpp.SessionState;
import org.mobicents.protocols.smpp.SessionType;
import org.mobicents.protocols.smpp.UnsupportedOperationException;
import org.mobicents.protocols.smpp.event.EventDispatcher;
import org.mobicents.protocols.smpp.event.SessionObserver;
import org.mobicents.protocols.smpp.event.SimpleEventDispatcher;
import org.mobicents.protocols.smpp.message.Bind;
import org.mobicents.protocols.smpp.message.BindReceiver;
import org.mobicents.protocols.smpp.message.BindResp;
import org.mobicents.protocols.smpp.message.BindTransceiver;
import org.mobicents.protocols.smpp.message.BindTransmitter;
import org.mobicents.protocols.smpp.message.SMPPPacket;
import org.mobicents.protocols.smpp.message.Unbind;
import org.mobicents.protocols.smpp.message.UnbindResp;
import org.mobicents.protocols.smpp.message.tlv.Tag;
import org.mobicents.protocols.smpp.net.SmscLink;
import org.mobicents.protocols.smpp.net.TcpLink;
import org.mobicents.protocols.smpp.util.APIConfig;
import org.mobicents.protocols.smpp.util.APIConfigFactory;
import org.mobicents.protocols.smpp.util.DefaultSequenceScheme;
import org.mobicents.protocols.smpp.util.PropertyNotFoundException;
import org.mobicents.protocols.smpp.util.SequenceNumberScheme;
import org.mobicents.protocols.smpp.version.SMPPVersion;
import org.mobicents.protocols.smpp.version.VersionException;
import org.mobicents.protocols.smpp.version.VersionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session {
    private static final AtomicInteger SESSION_ID = new AtomicInteger(1);
    private final Logger log;
    private String sessionId;
    private SMPPVersion version = VersionFactory.getDefaultVersion();
    private SessionType type;
    private AtomicReference<SessionState> state = new AtomicReference<SessionState>(SessionState.UNBOUND);
    private SmscLink smscLink;
    private SequenceNumberScheme numberScheme = new DefaultSequenceScheme();
    private EventDispatcher eventDispatcher;
    private Receiver receiver;
    private boolean useOptionalParams = this.version.isSupportTLV();
    private boolean validating = true;

    public Session(SmscLink link) {
        this.sessionId = "Session-" + SESSION_ID.getAndIncrement();
        this.log = LoggerFactory.getLogger((String)(Session.class + "." + this.sessionId));
        this.smscLink = link;
        this.initFromConfig();
    }

    public Session(String host, int port) throws UnknownHostException {
        this(new TcpLink(host, port));
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void addObserver(SessionObserver observer) {
        this.eventDispatcher.addObserver(observer);
    }

    public void removeObserver(SessionObserver observer) {
        this.eventDispatcher.removeObserver(observer);
    }

    public SmscLink getSmscLink() {
        return this.smscLink;
    }

    public EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    public void setEventDispatcher(EventDispatcher eventDispatcher) {
        EventDispatcher oldDispatcher = this.eventDispatcher;
        this.initNewDispatcher(oldDispatcher, eventDispatcher);
        this.eventDispatcher = eventDispatcher;
        if (oldDispatcher != null) {
            oldDispatcher.destroy();
        }
    }

    public SMPPVersion getVersion() {
        return this.version;
    }

    public void setVersion(SMPPVersion version) {
        this.version = version;
        this.useOptionalParams = version.isSupportTLV();
    }

    public SequenceNumberScheme getSequenceNumberScheme() {
        return this.numberScheme;
    }

    public void setSequenceNumberScheme(SequenceNumberScheme numberScheme) {
        this.numberScheme = numberScheme;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public void bind(SessionType type, String systemID, String password, String systemType) throws IOException {
        this.bind(type, systemID, password, systemType, 0, 0, null);
    }

    public void bind(SessionType type, String systemID, String password, String systemType, int typeOfNumber, int numberPlanIndicator, String addressRange) throws IOException {
        Bind bindRequest = type == SessionType.TRANSMITTER ? new BindTransmitter() : (type == SessionType.RECEIVER ? new BindReceiver() : new BindTransceiver());
        bindRequest.setVersion(this.version);
        bindRequest.setSystemId(systemID);
        bindRequest.setPassword(password);
        bindRequest.setSystemType(systemType);
        bindRequest.setAddressTon(typeOfNumber);
        bindRequest.setAddressNpi(numberPlanIndicator);
        bindRequest.setAddressRange(addressRange);
        this.bind(bindRequest);
    }

    public void bind(Bind bindRequest) throws IOException {
        if (this.receiver == null) {
            this.initReceiver();
        }
        if (this.getState() != SessionState.UNBOUND) {
            throw new IllegalStateException("Already binding or bound.");
        }
        this.type = bindRequest.getCommandId() == 2 ? SessionType.TRANSMITTER : (bindRequest.getCommandId() == 1 ? SessionType.RECEIVER : SessionType.TRANSCEIVER);
        if (!this.smscLink.isConnected()) {
            this.smscLink.connect();
        }
        this.setLinkTimeout("smppapi.connection.bind_timeout");
        this.log.debug("Sending bind packet to the SMSC..");
        this.sendPacketInternal(bindRequest);
        this.receiver.start();
    }

    public void unbind() throws IOException {
        this.sendPacketInternal(new Unbind());
    }

    public void sendPacket(SMPPPacket packet) throws IOException {
        int commandId = packet.getCommandId();
        switch (commandId) {
            case 1: 
            case 2: 
            case 9: {
                this.bind((Bind)packet);
                return;
            }
        }
        if (this.type == SessionType.RECEIVER && packet.isRequest() && commandId != 6 && commandId != 21) {
            throw new UnsupportedOperationException("Receiver connection cannot send command " + commandId);
        }
        this.sendPacketInternal(packet);
    }

    public void closeLink() throws IOException {
        if (this.getState() != SessionState.UNBOUND && this.getState() != SessionState.UNBINDING) {
            throw new IllegalStateException("Cannot close link while connection is bound.");
        }
        this.smscLink.disconnect();
    }

    public SessionState getState() {
        return this.state.get();
    }

    public Receiver getReceiver(Receiver receiver) {
        return receiver;
    }

    public void setReceiver(Receiver receiver) {
        if (this.receiver != null && this.receiver.isStarted()) {
            throw new IllegalStateException("Cannot change the receiver while it's running");
        }
        this.receiver = receiver;
    }

    public void processReceivedPacket(SMPPPacket packet) {
        switch (packet.getCommandId()) {
            case -2147483647: 
            case -2147483646: 
            case -2147483639: {
                this.processReceivedBindResponse((BindResp)packet);
                break;
            }
            case 6: {
                this.processReceivedUnbind((Unbind)packet);
                break;
            }
            case -2147483642: {
                this.processReceivedUnbindResponse((UnbindResp)packet);
                break;
            }
        }
    }

    private void setState(SessionState fromState, SessionState toState) {
        if (!this.state.compareAndSet(fromState, toState)) {
            this.log.error("Race condition in setting state - expected {} but is {}. New value is " + (Object)((Object)toState), (Object)fromState, (Object)this.getState());
        }
    }

    private void initFromConfig() {
        EventDispatcher dispatcher;
        APIConfig config = APIConfigFactory.getConfig();
        try {
            dispatcher = config.getClassInstance("smppapi.event.dispatcher", EventDispatcher.class);
        }
        catch (PropertyNotFoundException x) {
            this.log.debug("Config does not specify an event dispatcher. Using {}", SimpleEventDispatcher.class);
            dispatcher = new SimpleEventDispatcher();
        }
        this.setEventDispatcher(dispatcher);
    }

    private void initReceiver() {
        this.receiver = new ReceiverThread(this);
        this.receiver.setName(this.sessionId + "-Receiver");
    }

    private void initNewDispatcher(EventDispatcher oldDispatcher, EventDispatcher newDispatcher) {
        newDispatcher.init();
        if (oldDispatcher != null) {
            Collection<SessionObserver> observers = oldDispatcher.getObservers();
            for (SessionObserver observer : observers) {
                newDispatcher.addObserver(observer);
            }
        }
    }

    private void sendPacketInternal(SMPPPacket packet) throws IOException {
        if (packet.getSequenceNum() < 0L && this.numberScheme != null) {
            packet.setSequenceNum(this.numberScheme.nextNumber());
        }
        if (this.validating) {
            packet.validate(this.version);
        }
        this.smscLink.write(packet, this.useOptionalParams);
        this.processSentPacket(packet);
    }

    private void processSentPacket(SMPPPacket packet) {
        switch (packet.getCommandId()) {
            case 1: 
            case 2: 
            case 9: {
                this.processSentBind((Bind)packet);
                break;
            }
            case 6: {
                this.processSentUnbind((Unbind)packet);
                break;
            }
            case -2147483642: {
                this.processSentUnbindResponse((UnbindResp)packet);
                break;
            }
        }
    }

    private void processSentBind(Bind bindRequest) {
        this.setState(SessionState.UNBOUND, SessionState.BINDING);
    }

    private void processSentUnbind(Unbind unbindRequest) {
        this.setState(SessionState.BOUND, SessionState.UNBINDING);
    }

    private void processSentUnbindResponse(UnbindResp unbindResponse) {
        int status = unbindResponse.getCommandStatus();
        if (status == 0) {
            this.setState(SessionState.UNBINDING, SessionState.UNBOUND);
        }
    }

    private void processReceivedBindResponse(BindResp bindResponse) {
        int status = bindResponse.getCommandStatus();
        if (status == 0) {
            this.setState(SessionState.BINDING, SessionState.BOUND);
            this.negotiateVersion(bindResponse);
            this.setLinkTimeout("smppapi.net.link_timeout");
        } else {
            this.log.warn("Received a bind response with status {}", (Object)status);
            this.setState(SessionState.BINDING, SessionState.UNBOUND);
        }
    }

    private void negotiateVersion(BindResp bindResponse) {
        if (!bindResponse.isSet(Tag.SC_INTERFACE_VERSION)) {
            this.log.info("SMSC did not supply SC_INTERFACE_VERSION. Disabling optional parameter support.");
            this.useOptionalParams = false;
            return;
        }
        int versionId = 0;
        try {
            versionId = bindResponse.getTLVTable().getInt(Tag.SC_INTERFACE_VERSION);
            SMPPVersion smscVersion = VersionFactory.getVersion(versionId);
            this.log.info("SMSC states its version as {}", (Object)smscVersion);
            if (smscVersion.isOlderThan(this.version)) {
                this.version = smscVersion;
                this.useOptionalParams = this.version.isSupportTLV();
            }
        }
        catch (VersionException x) {
            this.log.debug("SMSC implements a version I don't know: {}", (Object)versionId);
        }
    }

    private void processReceivedUnbind(Unbind unbindRequest) {
        this.setState(SessionState.BOUND, SessionState.UNBINDING);
    }

    private void processReceivedUnbindResponse(UnbindResp unbindResponse) {
        int status = unbindResponse.getCommandStatus();
        if (status == 0) {
            this.setState(SessionState.UNBINDING, SessionState.UNBOUND);
        } else {
            this.log.warn("Received an unbind response with status {}", (Object)status);
        }
    }

    private void setLinkTimeout(String propName) {
        try {
            if (this.smscLink.isTimeoutSupported()) {
                APIConfig config = APIConfigFactory.getConfig();
                int linkTimeout = config.getInt(propName);
                this.smscLink.setTimeout(linkTimeout);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Set the link timeout to {}", (Object)linkTimeout);
                }
            } else {
                this.log.info("SMSC link implementation does not support timeouts.");
            }
        }
        catch (PropertyNotFoundException x) {
            this.log.debug("Not setting link timeout as it is not configured.");
        }
    }
}

