/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp;

import java.io.IOException;
import org.mobicents.protocols.smpp.Receiver;
import org.mobicents.protocols.smpp.Session;
import org.mobicents.protocols.smpp.SessionState;
import org.mobicents.protocols.smpp.event.ReceiverExceptionEvent;
import org.mobicents.protocols.smpp.event.ReceiverExitEvent;
import org.mobicents.protocols.smpp.message.SMPPPacket;
import org.mobicents.protocols.smpp.net.ReadTimeoutException;
import org.mobicents.protocols.smpp.util.APIConfig;
import org.mobicents.protocols.smpp.util.APIConfigFactory;
import org.mobicents.protocols.smpp.util.PacketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiverThread
implements Receiver,
Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ReceiverThread.class);
    private Thread thread;
    private boolean running;
    private Session session;
    private PacketFactory packetFactory = new PacketFactory();

    public ReceiverThread() {
        this.thread = new Thread(this);
        this.thread.setDaemon(true);
    }

    public ReceiverThread(Session session) {
        this();
        this.session = session;
    }

    public PacketFactory getPacketFactory() {
        return this.packetFactory;
    }

    public void setPacketFactory(PacketFactory packetFactory) {
        this.packetFactory = packetFactory;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public String getName() {
        return this.thread.getName();
    }

    public void setName(String name) {
        this.thread.setName(name);
    }

    public void run() {
        LOG.debug("Receiver thread starting.");
        ReceiverExitEvent exitEvent = null;
        try {
            this.running = true;
            exitEvent = this.processPackets();
        }
        catch (Exception x) {
            LOG.error("Error in receiver thread", (Throwable)x);
            exitEvent = new ReceiverExitEvent(this.session, x);
        }
        this.session.getEventDispatcher().notifyObservers(this.session, exitEvent);
        LOG.debug("Destroying event dispatcher.");
        this.session.getEventDispatcher().destroy();
        LOG.debug("Receiver thread exiting.");
    }

    public boolean isStarted() {
        return this.thread.isAlive();
    }

    public void start() {
        this.thread.start();
    }

    public void stop() {
        this.running = false;
    }

    private ReceiverExitEvent processPackets() throws Exception {
        ReceiverExitEvent exitEvent = null;
        ReceiverExceptionEvent excpEvent = null;
        int ioExceptions = 0;
        APIConfig config = APIConfigFactory.getConfig();
        int ioExceptionLimit = config.getInt("smppapi.connection.rcv_daemon.ioex_count", 5);
        SMPPPacket packet = null;
        while (this.running && this.session.getState() != SessionState.UNBOUND) {
            SessionState state;
            try {
                packet = this.readNextPacket();
                if (packet == null) continue;
                this.session.processReceivedPacket(packet);
                this.session.getEventDispatcher().notifyObservers(this.session, packet);
                ioExceptions = 0;
            }
            catch (ReadTimeoutException x) {
                state = this.session.getState();
                if (state == SessionState.BINDING) {
                    LOG.debug("Bind timeout occurred.");
                    exitEvent = new ReceiverExitEvent(this.session, null, state);
                    exitEvent.setReason(1);
                    break;
                }
                if (state != SessionState.BOUND) continue;
                LOG.debug("Read timeout occurred.");
                excpEvent = new ReceiverExceptionEvent(this.session, x);
                this.session.getEventDispatcher().notifyObservers(this.session, excpEvent);
            }
            catch (IOException x) {
                LOG.debug("Exception in receiver", (Throwable)x);
                if (++ioExceptions < ioExceptionLimit) continue;
                state = this.session.getState();
                exitEvent = new ReceiverExitEvent(this.session, x, state);
                exitEvent.setReason(2);
                break;
            }
        }
        if (exitEvent == null) {
            exitEvent = new ReceiverExitEvent(this.session);
        }
        return exitEvent;
    }

    private SMPPPacket readNextPacket() throws IOException {
        return this.session.getSmscLink().read();
    }
}

