/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp;

import java.io.IOException;
import java.io.Serializable;
import org.mobicents.protocols.smpp.util.PacketDecoder;
import org.mobicents.protocols.smpp.util.PacketEncoder;

public class Address
implements Serializable {
    private static final long serialVersionUID = 2L;
    private int ton = 0;
    private int npi = 0;
    private String address = "";

    public Address() {
    }

    public Address(int ton, int npi, String address) {
        this.ton = ton;
        this.npi = npi;
        this.address = address;
    }

    public int getTON() {
        return this.ton;
    }

    public void setTON(int ton) {
        this.ton = ton;
    }

    public int getNPI() {
        return this.npi;
    }

    public void setNPI(int npi) {
        this.npi = npi;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address != null ? address : "";
    }

    public int hashCode() {
        StringBuilder buf = new StringBuilder();
        buf.append(Integer.toString(this.ton)).append(':');
        buf.append(Integer.toString(this.npi)).append(':');
        if (this.address != null) {
            buf.append(this.address);
        }
        return buf.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Address) {
            Address a = (Address)obj;
            return a.ton == this.ton && a.npi == this.npi && a.address.equals(this.address);
        }
        return false;
    }

    public int getLength() {
        return 3 + this.address.length();
    }

    public void writeTo(PacketEncoder encoder) throws IOException {
        encoder.writeUInt1(this.ton);
        encoder.writeUInt1(this.npi);
        encoder.writeCString(this.address);
    }

    public void readFrom(PacketDecoder decoder) {
        this.ton = decoder.readUInt1();
        this.npi = decoder.readUInt1();
        this.address = decoder.readCString();
    }

    public String toString() {
        return new StringBuffer(25).append(Integer.toString(this.ton)).append(':').append(Integer.toString(this.npi)).append(':').append(this.address).toString();
    }
}

