/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.sctp.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.net.InetSocketAddress;
import javolution.util.FastMap;
import org.apache.log4j.Logger;
import org.mobicents.protocols.api.Association;
import org.mobicents.protocols.api.AssociationType;
import org.mobicents.protocols.api.IpChannelType;
import org.mobicents.protocols.api.Server;
import org.mobicents.protocols.sctp.AssociationMap;
import org.mobicents.protocols.sctp.netty.NettyAssociationImpl;
import org.mobicents.protocols.sctp.netty.NettySctpChannelInboundHandlerAdapter;
import org.mobicents.protocols.sctp.netty.NettySctpManagementImpl;
import org.mobicents.protocols.sctp.netty.NettyServerImpl;

public class NettySctpServerHandler
extends NettySctpChannelInboundHandlerAdapter {
    Logger logger = Logger.getLogger(NettySctpServerHandler.class);
    private final NettyServerImpl serverImpl;
    private final NettySctpManagementImpl managementImpl;

    public NettySctpServerHandler(NettyServerImpl serverImpl, NettySctpManagementImpl managementImpl) {
        this.serverImpl = serverImpl;
        this.managementImpl = managementImpl;
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        this.logger.warn((Object)String.format("ChannelUnregistered event: association=%s", this.association));
        if (this.association != null) {
            this.association.setChannelHandler(null);
        }
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("channelRegistered event: association=%s", this.association));
        }
        Channel channel = ctx.channel();
        InetSocketAddress sockAdd = (InetSocketAddress)channel.remoteAddress();
        String host = sockAdd.getAddress().getHostAddress();
        int port = sockAdd.getPort();
        boolean provisioned = false;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("Received connect request from peer host=%s port=%d", host, port));
        }
        AssociationMap<String, Association> associations = this.managementImpl.associations;
        FastMap.Entry n = associations.head();
        FastMap.Entry end = associations.tail();
        while ((n = n.getNext()) != end && !provisioned) {
            NettyAssociationImpl association = (NettyAssociationImpl)n.getValue();
            if (!this.serverImpl.getName().equals(association.getServerName()) || association.getAssociationType() != AssociationType.SERVER || port != association.getPeerPort() || !host.equals(association.getPeerAddress())) continue;
            provisioned = true;
            if (!association.isStarted()) {
                this.logger.error((Object)String.format("Received connect request for Association=%s but not started yet. Droping the connection!", association.getName()));
                channel.close();
                return;
            }
            this.association = association;
            this.channel = channel;
            this.ctx = ctx;
            this.association.setChannelHandler(this);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)String.format("Connected %s", association));
            }
            if (association.getIpChannelType() != IpChannelType.TCP) break;
            this.association.markAssociationUp(1, 1);
            break;
        }
        if (!provisioned && this.serverImpl.isAcceptAnonymousConnections() && this.managementImpl.getServerListener() != null) {
            if (this.serverImpl.getMaxConcurrentConnectionsCount() > 0 && this.serverImpl.anonymAssociations.size() >= this.serverImpl.getMaxConcurrentConnectionsCount()) {
                this.logger.warn((Object)String.format("Incoming anonymous connection is rejected because of too many active connections to Server=%s", this.serverImpl));
                channel.close();
                return;
            }
            provisioned = true;
            NettyAssociationImpl anonymAssociation = new NettyAssociationImpl(host, port, this.serverImpl.getName(), this.serverImpl.getIpChannelType(), this.serverImpl);
            anonymAssociation.setManagement(this.managementImpl);
            try {
                this.managementImpl.getServerListener().onNewRemoteConnection((Server)this.serverImpl, (Association)anonymAssociation);
            }
            catch (Throwable e) {
                this.logger.warn((Object)String.format("Exception when invoking ServerListener.onNewRemoteConnection() Ass=%s", anonymAssociation), e);
                channel.close();
                return;
            }
            if (!anonymAssociation.isStarted()) {
                this.logger.info((Object)String.format("Rejected anonymous %s", anonymAssociation));
                channel.close();
                return;
            }
            this.association = anonymAssociation;
            this.channel = channel;
            this.ctx = ctx;
            this.association.setChannelHandler(this);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)String.format("Accepted anonymous %s", anonymAssociation));
            }
            if (this.association.getIpChannelType() == IpChannelType.TCP) {
                this.association.markAssociationUp(1, 1);
            }
        }
        if (!provisioned) {
            this.logger.warn((Object)String.format("Received connect request from non provisioned %s:%d address. Closing Channel", host, port));
            ctx.close();
        }
    }

    public void channelActive(ChannelHandlerContext ctx) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("channelActive event: association=" + this.association));
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.logger.error((Object)("ExceptionCaught for Associtaion: " + this.association.getName() + "\n"), cause);
        ctx.close();
    }
}

