/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.sctp.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.sctp.SctpChannel;
import io.netty.channel.sctp.SctpChannelOption;
import io.netty.channel.sctp.SctpMessage;
import io.netty.channel.sctp.nio.NioSctpChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javolution.util.FastList;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.mobicents.protocols.api.Association;
import org.mobicents.protocols.api.AssociationListener;
import org.mobicents.protocols.api.AssociationType;
import org.mobicents.protocols.api.CongestionListener;
import org.mobicents.protocols.api.IpChannelType;
import org.mobicents.protocols.api.ManagementEventListener;
import org.mobicents.protocols.api.PayloadData;
import org.mobicents.protocols.sctp.netty.NettySctpChannelInboundHandlerAdapter;
import org.mobicents.protocols.sctp.netty.NettySctpClientChannelInitializer;
import org.mobicents.protocols.sctp.netty.NettySctpManagementImpl;
import org.mobicents.protocols.sctp.netty.NettyServerImpl;
import org.mobicents.protocols.sctp.netty.NettyTcpClientChannelInitializer;

public class NettyAssociationImpl
implements Association {
    protected static final Logger logger = Logger.getLogger((String)NettyAssociationImpl.class.getName());
    private static final String NAME = "name";
    private static final String SERVER_NAME = "serverName";
    private static final String HOST_ADDRESS = "hostAddress";
    private static final String HOST_PORT = "hostPort";
    private static final String PEER_ADDRESS = "peerAddress";
    private static final String PEER_PORT = "peerPort";
    private static final String ASSOCIATION_TYPE = "assoctype";
    private static final String IPCHANNEL_TYPE = "ipChannelType";
    private static final String EXTRA_HOST_ADDRESS = "extraHostAddress";
    private static final String EXTRA_HOST_ADDRESS_SIZE = "extraHostAddresseSize";
    private String hostAddress;
    private int hostPort;
    private String peerAddress;
    private int peerPort;
    private String serverName;
    private String name;
    private IpChannelType ipChannelType;
    private String[] extraHostAddresses;
    private NettyServerImpl server;
    private AssociationType type;
    private AssociationListener associationListener = null;
    private NettySctpManagementImpl management;
    private volatile boolean started = false;
    protected volatile boolean up = false;
    private NettySctpChannelInboundHandlerAdapter channelHandler;
    protected int congLevel;
    protected static final XMLFormat<NettyAssociationImpl> ASSOCIATION_XML = new XMLFormat<NettyAssociationImpl>(NettyAssociationImpl.class){

        public void read(XMLFormat.InputElement xml, NettyAssociationImpl association) throws XMLStreamException {
            association.name = xml.getAttribute(NettyAssociationImpl.NAME, "");
            association.type = AssociationType.getAssociationType((String)xml.getAttribute(NettyAssociationImpl.ASSOCIATION_TYPE, ""));
            association.hostAddress = xml.getAttribute(NettyAssociationImpl.HOST_ADDRESS, "");
            association.hostPort = xml.getAttribute(NettyAssociationImpl.HOST_PORT, 0);
            association.peerAddress = xml.getAttribute(NettyAssociationImpl.PEER_ADDRESS, "");
            association.peerPort = xml.getAttribute(NettyAssociationImpl.PEER_PORT, 0);
            association.serverName = xml.getAttribute(NettyAssociationImpl.SERVER_NAME, "");
            association.ipChannelType = IpChannelType.getInstance((int)xml.getAttribute(NettyAssociationImpl.IPCHANNEL_TYPE, IpChannelType.SCTP.getCode()));
            if (association.ipChannelType == null) {
                association.ipChannelType = IpChannelType.SCTP;
            }
            int extraHostAddressesSize = xml.getAttribute(NettyAssociationImpl.EXTRA_HOST_ADDRESS_SIZE, 0);
            NettyAssociationImpl.access$802(association, new String[extraHostAddressesSize]);
            for (int i = 0; i < extraHostAddressesSize; ++i) {
                ((NettyAssociationImpl)association).extraHostAddresses[i] = (String)xml.get(NettyAssociationImpl.EXTRA_HOST_ADDRESS, String.class);
            }
        }

        public void write(NettyAssociationImpl association, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(NettyAssociationImpl.NAME, association.name);
            xml.setAttribute(NettyAssociationImpl.ASSOCIATION_TYPE, association.type.getType());
            xml.setAttribute(NettyAssociationImpl.HOST_ADDRESS, association.hostAddress);
            xml.setAttribute(NettyAssociationImpl.HOST_PORT, association.hostPort);
            xml.setAttribute(NettyAssociationImpl.PEER_ADDRESS, association.peerAddress);
            xml.setAttribute(NettyAssociationImpl.PEER_PORT, association.peerPort);
            xml.setAttribute(NettyAssociationImpl.SERVER_NAME, association.serverName);
            xml.setAttribute(NettyAssociationImpl.IPCHANNEL_TYPE, association.ipChannelType.getCode());
            xml.setAttribute(NettyAssociationImpl.EXTRA_HOST_ADDRESS_SIZE, association.extraHostAddresses != null ? association.extraHostAddresses.length : 0);
            if (association.extraHostAddresses != null) {
                for (String s : association.extraHostAddresses) {
                    xml.add((Object)s, NettyAssociationImpl.EXTRA_HOST_ADDRESS, String.class);
                }
            }
        }
    };

    public NettyAssociationImpl() {
    }

    public NettyAssociationImpl(String hostAddress, int hostPort, String peerAddress, int peerPort, String assocName, IpChannelType ipChannelType, String[] extraHostAddresses) throws IOException {
        this();
        this.hostAddress = hostAddress;
        this.hostPort = hostPort;
        this.peerAddress = peerAddress;
        this.peerPort = peerPort;
        this.name = assocName;
        this.ipChannelType = ipChannelType;
        this.extraHostAddresses = extraHostAddresses;
        this.type = AssociationType.CLIENT;
    }

    public NettyAssociationImpl(String peerAddress, int peerPort, String serverName, String assocName, IpChannelType ipChannelType) {
        this();
        this.peerAddress = peerAddress;
        this.peerPort = peerPort;
        this.serverName = serverName;
        this.name = assocName;
        this.ipChannelType = ipChannelType;
        this.type = AssociationType.SERVER;
    }

    protected NettyAssociationImpl(String peerAddress, int peerPort, String serverName, IpChannelType ipChannelType, NettyServerImpl server) {
        this();
        this.peerAddress = peerAddress;
        this.peerPort = peerPort;
        this.serverName = serverName;
        this.ipChannelType = ipChannelType;
        this.server = server;
        this.type = AssociationType.ANONYMOUS_SERVER;
    }

    public NettySctpManagementImpl getManagement() {
        return this.management;
    }

    public IpChannelType getIpChannelType() {
        return this.ipChannelType;
    }

    public AssociationType getAssociationType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isConnected() {
        return this.started && this.up;
    }

    public boolean isUp() {
        return this.up;
    }

    public AssociationListener getAssociationListener() {
        return this.associationListener;
    }

    public void setAssociationListener(AssociationListener associationListener) {
        this.associationListener = associationListener;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public int getHostPort() {
        return this.hostPort;
    }

    public String getPeerAddress() {
        return this.peerAddress;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String[] getExtraHostAddresses() {
        return this.extraHostAddresses;
    }

    public void send(PayloadData payloadData) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Tx : Ass=%s %s", this.getName(), payloadData));
        }
        NettySctpChannelInboundHandlerAdapter handler = this.checkSocketIsOpen();
        ByteBuf byteBuf = payloadData.getByteBuf();
        if (this.ipChannelType == IpChannelType.SCTP) {
            SctpMessage sctpMessage = new SctpMessage(payloadData.getPayloadProtocolId(), payloadData.getStreamNumber(), payloadData.isUnordered(), byteBuf);
            handler.writeAndFlush(sctpMessage);
        } else {
            handler.writeAndFlush(byteBuf);
        }
    }

    private NettySctpChannelInboundHandlerAdapter checkSocketIsOpen() throws Exception {
        NettySctpChannelInboundHandlerAdapter handler = this.channelHandler;
        if (!this.started || handler == null) {
            throw new Exception(String.format("Association is not started or underlying sctp/tcp channel is down for Association=%s", this.name));
        }
        return handler;
    }

    public ByteBufAllocator getByteBufAllocator() {
        if (this.channelHandler != null) {
            return this.channelHandler.channel.alloc();
        }
        return null;
    }

    public int getCongestionLevel() {
        return this.congLevel;
    }

    protected void setCongestionLevel(int val) {
        if (this.congLevel != val) {
            logger.warn((Object)("Outgoing congestion control: SCTP: Changing of congestion level for Association=" + this.name + " " + this.congLevel + "->" + val));
        }
        for (CongestionListener lstr : this.management.getCongestionListeners()) {
            try {
                lstr.onCongLevelChanged((Association)this, this.congLevel, val);
            }
            catch (Throwable ee) {
                logger.error((Object)"Exception while invoking onAssociationAdded", ee);
            }
        }
        this.congLevel = val;
    }

    public void acceptAnonymousAssociation(AssociationListener associationListener) throws Exception {
        this.associationListener = associationListener;
        if (this.getAssociationType() != AssociationType.ANONYMOUS_SERVER) {
            throw new UnsupportedOperationException("Association.acceptAnonymousAssociation() can be applied only for anonymous associations");
        }
        this.start();
    }

    public void rejectAnonymousAssociation() {
    }

    public void stopAnonymousAssociation() throws Exception {
        if (this.getAssociationType() != AssociationType.ANONYMOUS_SERVER) {
            throw new UnsupportedOperationException("Association.stopAnonymousAssociation() can be applied only for anonymous associations");
        }
        this.stop();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Association [name=").append(this.name).append(", associationType=").append(this.type).append(", ipChannelType=").append(this.ipChannelType).append(", hostAddress=").append(this.hostAddress).append(", hostPort=").append(this.hostPort).append(", peerAddress=").append(this.peerAddress).append(", peerPort=").append(this.peerPort).append(", serverName=").append(this.serverName);
        sb.append(", extraHostAddress=[");
        if (this.extraHostAddresses != null) {
            for (int i = 0; i < this.extraHostAddresses.length; ++i) {
                String extraHostAddress = this.extraHostAddresses[i];
                sb.append(extraHostAddress);
                sb.append(", ");
            }
        }
        sb.append("]]");
        return sb.toString();
    }

    protected void setManagement(NettySctpManagementImpl management) {
        this.management = management;
    }

    protected void start() throws Exception {
        if (this.associationListener == null) {
            throw new NullPointerException(String.format("AssociationListener is null for Associatoion=%s", this.name));
        }
        if (this.type == AssociationType.CLIENT) {
            this.scheduleConnect();
        }
        this.started = true;
        if (logger.isInfoEnabled() && this.type != AssociationType.ANONYMOUS_SERVER) {
            logger.info((Object)String.format("Started Association=%s", this));
        }
        for (ManagementEventListener lstr : this.management.getManagementEventListeners()) {
            try {
                lstr.onAssociationStarted((Association)this);
            }
            catch (Throwable ee) {
                logger.error((Object)"Exception while invoking onAssociationStarted", ee);
            }
        }
    }

    protected void stop() throws Exception {
        if (logger.isInfoEnabled()) {
            logger.info((Object)String.format("Management requested to stop %s", this.toString()));
        }
        this.started = false;
        for (ManagementEventListener lstr : this.management.getManagementEventListeners()) {
            try {
                lstr.onAssociationStopped((Association)this);
            }
            catch (Throwable ee) {
                logger.error((Object)"Exception while invoking onAssociationStopped", ee);
            }
        }
        NettySctpChannelInboundHandlerAdapter handler = this.channelHandler;
        if (handler != null) {
            handler.closeChannel();
        }
    }

    protected void read(PayloadData payload) {
        try {
            this.associationListener.onPayload((Association)this, payload);
        }
        catch (Exception e) {
            logger.error((Object)String.format("Error while calling Listener for Association=%s.Payload=%s", this.name, payload), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markAssociationUp(int maxInboundStreams, int maxOutboundStreams) {
        if (this.server != null) {
            FastList<Association> fastList = this.server.anonymAssociations;
            synchronized (fastList) {
                this.server.anonymAssociations.add((Object)this);
            }
        }
        this.up = true;
        this.getAssociationListener().onCommunicationUp((Association)this, maxInboundStreams, maxOutboundStreams);
        for (ManagementEventListener lstr : this.management.getManagementEventListeners()) {
            try {
                lstr.onAssociationUp((Association)this);
            }
            catch (Throwable ee) {
                logger.error((Object)"Exception while invoking onAssociationUp", ee);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markAssociationDown() {
        if (this.up) {
            this.up = false;
            for (ManagementEventListener lstr : this.management.getManagementEventListeners()) {
                try {
                    lstr.onAssociationDown((Association)this);
                }
                catch (Throwable ee) {
                    logger.error((Object)"Exception while invoking onAssociationDown", ee);
                }
            }
            this.getAssociationListener().onCommunicationShutdown((Association)this);
            if (this.server != null) {
                FastList<Association> fastList = this.server.anonymAssociations;
                synchronized (fastList) {
                    this.server.anonymAssociations.remove((Object)this);
                }
            }
        }
    }

    protected void scheduleConnect() {
        int connectDelay = this.management.getConnectDelay();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Scheduling of a channel connection: Association=%s, connectDelay=%d", this, connectDelay));
        }
        ScheduledExecutorService loop = this.management.getClientExecutor();
        loop.schedule(new Runnable(){

            @Override
            public void run() {
                NettyAssociationImpl.this.connect();
            }
        }, (long)connectDelay, TimeUnit.MILLISECONDS);
    }

    protected void setChannelHandler(NettySctpChannelInboundHandlerAdapter channelHandler) {
        this.channelHandler = channelHandler;
    }

    protected void connect() {
        InetSocketAddress localAddress;
        Bootstrap b;
        if (!this.started || this.up) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Initiating connection started: Association=%s", this));
        }
        try {
            EventLoopGroup group = this.management.getBossGroup();
            b = new Bootstrap();
            b.group(group);
            if (this.ipChannelType == IpChannelType.SCTP) {
                b.channel(NioSctpChannel.class);
                this.applySctpOptions(b);
                b.handler((ChannelHandler)new NettySctpClientChannelInitializer(this));
            } else {
                b.channel(NioSocketChannel.class);
                b.option(ChannelOption.TCP_NODELAY, (Object)true);
                b.handler((ChannelHandler)new NettyTcpClientChannelInitializer(this));
            }
            localAddress = new InetSocketAddress(this.hostAddress, this.hostPort);
        }
        catch (Exception e) {
            logger.error((Object)String.format("Exception while creating connection for Association=%s", this.getName()), (Throwable)e);
            this.scheduleConnect();
            return;
        }
        try {
            ChannelFuture bindFuture = b.bind((SocketAddress)localAddress).sync();
            Channel channel = bindFuture.channel();
            if (this.ipChannelType == IpChannelType.SCTP) {
                SctpChannel sctpChannel = (SctpChannel)channel;
                if (this.extraHostAddresses != null) {
                    for (int count = 0; count < this.extraHostAddresses.length; ++count) {
                        String localSecondaryAddress = this.extraHostAddresses[count];
                        InetAddress localSecondaryInetAddress = InetAddress.getByName(localSecondaryAddress);
                        sctpChannel.bindAddress(localSecondaryInetAddress).sync();
                    }
                }
            }
            InetSocketAddress remoteAddress = new InetSocketAddress(this.peerAddress, this.peerPort);
            bindFuture.channel().connect((SocketAddress)remoteAddress);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Initiating connection scheduled: Association=%s remoteAddress=%s", this, remoteAddress));
            }
        }
        catch (Exception e) {
            logger.error((Object)String.format("Exception while finishing connection for Association=%s", this.getName()), (Throwable)e);
        }
    }

    private void applySctpOptions(Bootstrap b) {
        b.option((ChannelOption)SctpChannelOption.SCTP_NODELAY, (Object)this.management.getOptionSctpNodelay());
        b.option((ChannelOption)SctpChannelOption.SCTP_DISABLE_FRAGMENTS, (Object)this.management.getOptionSctpDisableFragments());
        b.option((ChannelOption)SctpChannelOption.SCTP_FRAGMENT_INTERLEAVE, (Object)this.management.getOptionSctpFragmentInterleave());
        b.option((ChannelOption)SctpChannelOption.SCTP_INIT_MAXSTREAMS, (Object)this.management.getOptionSctpInitMaxstreams());
        b.option(SctpChannelOption.SO_SNDBUF, (Object)this.management.getOptionSoSndbuf());
        b.option(SctpChannelOption.SO_RCVBUF, (Object)this.management.getOptionSoRcvbuf());
        b.option(SctpChannelOption.SO_LINGER, (Object)this.management.getOptionSoLinger());
    }

    static /* synthetic */ String[] access$802(NettyAssociationImpl x0, String[] x1) {
        x0.extraHostAddresses = x1;
        return x1;
    }
}

