/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.sctp;

import com.sun.nio.sctp.AssociationChangeNotification;
import com.sun.nio.sctp.SctpChannel;
import com.sun.nio.sctp.SctpServerChannel;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javolution.util.FastList;
import javolution.util.FastMap;
import org.apache.log4j.Logger;
import org.mobicents.protocols.api.Association;
import org.mobicents.protocols.api.IpChannelType;
import org.mobicents.protocols.api.Server;
import org.mobicents.protocols.sctp.AssociationImpl;
import org.mobicents.protocols.sctp.AssociationMap;
import org.mobicents.protocols.sctp.ChangeRequest;
import org.mobicents.protocols.sctp.ManagementImpl;
import org.mobicents.protocols.sctp.ServerImpl;

public class SelectorThread
implements Runnable {
    protected static final Logger logger = Logger.getLogger(SelectorThread.class);
    protected Selector selector;
    protected ManagementImpl management = null;
    protected volatile boolean started = true;

    protected SelectorThread(Selector selector, ManagementImpl management) {
        this.selector = selector;
        this.management = management;
    }

    protected void setStarted(boolean started) {
        this.started = started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (logger.isInfoEnabled()) {
            logger.info((Object)String.format("SelectorThread for Management=%s started.", this.management.getName()));
        }
        while (this.started) {
            try {
                FastList<ChangeRequest> pendingChanges;
                FastList<ChangeRequest> fastList = pendingChanges = this.management.getPendingChanges();
                synchronized (fastList) {
                    for (ChangeRequest change : pendingChanges) {
                        switch (change.getType()) {
                            case 2: {
                                pendingChanges.remove((Object)change);
                                SelectionKey key = change.getSocketChannel().keyFor(this.selector);
                                key.interestOps(change.getOps());
                                break;
                            }
                            case 1: {
                                pendingChanges.remove((Object)change);
                                SelectionKey key1 = change.getSocketChannel().register(this.selector, change.getOps());
                                key1.attach(change.getAssociation());
                                break;
                            }
                            case 3: {
                                if (!change.getAssociation().isStarted()) {
                                    pendingChanges.remove((Object)change);
                                    break;
                                }
                                if (change.getExecutionTime() > System.currentTimeMillis()) break;
                                pendingChanges.remove((Object)change);
                                change.getAssociation().initiateConnection();
                                break;
                            }
                            case 4: {
                                pendingChanges.remove((Object)change);
                                change.getAssociation().close();
                            }
                        }
                    }
                }
                this.selector.select(500L);
                Iterator<SelectionKey> selectedKeys = this.selector.selectedKeys().iterator();
                while (selectedKeys.hasNext()) {
                    SelectionKey key = selectedKeys.next();
                    selectedKeys.remove();
                    if (!key.isValid()) continue;
                    if (key.isConnectable()) {
                        this.finishConnection(key);
                        continue;
                    }
                    if (key.isAcceptable()) {
                        this.accept(key);
                        continue;
                    }
                    if (key.isReadable()) {
                        this.read(key);
                        continue;
                    }
                    if (!key.isWritable()) continue;
                    this.write(key);
                }
            }
            catch (Exception e) {
                logger.error((Object)"Error while selecting the ready keys", (Throwable)e);
            }
        }
        try {
            this.selector.close();
        }
        catch (IOException e) {
            logger.error((Object)String.format("Error while closing Selector for SCTP Management=%s", this.management.getName()));
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)String.format("SelectorThread for Management=%s stopped.", this.management.getName()));
        }
    }

    private void accept(SelectionKey key) throws IOException {
        if (key.channel() instanceof ServerSocketChannel) {
            this.acceptTcp(key);
        } else {
            this.acceptSctp(key);
        }
    }

    private void acceptSctp(SelectionKey key) throws IOException {
        SctpServerChannel serverSocketChannel = (SctpServerChannel)key.channel();
        SctpChannel socketChannel = serverSocketChannel.accept();
        Set<SocketAddress> peerAddresses = socketChannel.getRemoteAddresses();
        this.doAccept(serverSocketChannel, socketChannel, peerAddresses);
    }

    private void acceptTcp(SelectionKey key) throws IOException {
        ServerSocketChannel serverSocketChannel = (ServerSocketChannel)key.channel();
        SocketChannel socketChannel = serverSocketChannel.accept();
        HashSet<SocketAddress> peerAddresses = new HashSet<SocketAddress>();
        peerAddresses.add(socketChannel.getRemoteAddress());
        this.doAccept(serverSocketChannel, socketChannel, peerAddresses);
    }

    private void doAccept(AbstractSelectableChannel serverSocketChannel, AbstractSelectableChannel socketChannel, Set<SocketAddress> peerAddresses) throws IOException, ClosedChannelException {
        boolean provisioned = false;
        int port = 0;
        InetAddress inetAddress = null;
        int firstPort = 0;
        InetAddress firstInetAddress = null;
        for (Server srv : this.management.servers) {
            ServerImpl srvv = (ServerImpl)srv;
            if (srvv.getIpChannel() == serverSocketChannel) {
                for (SocketAddress sockAdd : peerAddresses) {
                    inetAddress = ((InetSocketAddress)sockAdd).getAddress();
                    port = ((InetSocketAddress)sockAdd).getPort();
                    if (firstInetAddress == null) {
                        firstInetAddress = inetAddress;
                        firstPort = port;
                    }
                    AssociationMap<String, Association> associations = this.management.associations;
                    FastMap.Entry n = associations.head();
                    FastMap.Entry end = associations.tail();
                    while ((n = n.getNext()) != end && !provisioned) {
                        AssociationImpl association = (AssociationImpl)n.getValue();
                        if (!srv.getName().equals(association.getServerName()) || port != association.getPeerPort() || !inetAddress.getHostAddress().equals(association.getPeerAddress())) continue;
                        provisioned = true;
                        if (!association.isStarted()) {
                            logger.error((Object)String.format("Received connect request for Association=%s but not started yet. Droping the connection! ", association.getName()));
                            socketChannel.close();
                            break;
                        }
                        association.setSocketChannel(socketChannel);
                        socketChannel.configureBlocking(false);
                        SelectionKey key1 = socketChannel.register(this.selector, 1);
                        key1.attach(association);
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)String.format("Connected %s", association));
                        }
                        if (association.getIpChannelType() != IpChannelType.TCP) break;
                        AssociationChangeNotification.AssocChangeEvent ace = AssociationChangeNotification.AssocChangeEvent.COMM_UP;
                        AssociationChangeNotification2 acn = new AssociationChangeNotification2(ace);
                        association.associationHandler.handleNotification((AssociationChangeNotification)acn, association);
                        break;
                    }
                    if (!provisioned) continue;
                    break;
                }
                if (!provisioned && srv.isAcceptAnonymousConnections() && this.management.getServerListener() != null) {
                    if (srvv.getMaxConcurrentConnectionsCount() > 0 && srvv.anonymAssociations.size() >= srvv.getMaxConcurrentConnectionsCount()) {
                        logger.warn((Object)String.format("Incoming anonymous connection is rejected because of too many active connections to Server=%s", srv));
                        try {
                            socketChannel.close();
                        }
                        catch (Exception i$) {
                            // empty catch block
                        }
                        return;
                    }
                    provisioned = true;
                    AssociationImpl anonymAssociation = new AssociationImpl(firstInetAddress.getHostAddress(), firstPort, srv.getName(), srv.getIpChannelType(), srvv);
                    anonymAssociation.setManagement(this.management);
                    anonymAssociation.setSocketChannel(socketChannel);
                    socketChannel.configureBlocking(false);
                    try {
                        this.management.getServerListener().onNewRemoteConnection(srv, (Association)anonymAssociation);
                    }
                    catch (Throwable e) {
                        logger.warn((Object)String.format("Exception when invoking ServerListener.onNewRemoteConnection() Ass=%s", anonymAssociation), e);
                        try {
                            socketChannel.close();
                        }
                        catch (Exception associations) {
                            // empty catch block
                        }
                        return;
                    }
                    if (!anonymAssociation.isStarted()) {
                        logger.info((Object)String.format("Rejected anonymous %s", anonymAssociation));
                        try {
                            socketChannel.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        return;
                    }
                    SelectionKey key1 = socketChannel.register(this.selector, 1);
                    key1.attach(anonymAssociation);
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)String.format("Accepted anonymous %s", anonymAssociation));
                    }
                    if (anonymAssociation.getIpChannelType() == IpChannelType.TCP) {
                        AssociationChangeNotification.AssocChangeEvent ace = AssociationChangeNotification.AssocChangeEvent.COMM_UP;
                        AssociationChangeNotification2 acn = new AssociationChangeNotification2(ace);
                        anonymAssociation.associationHandler.handleNotification((AssociationChangeNotification)acn, anonymAssociation);
                    }
                }
            }
            if (!provisioned) continue;
            break;
        }
        if (!provisioned) {
            logger.warn((Object)String.format("Received connect request from non provisioned %s:%d address. Closing Channel", inetAddress.getHostAddress(), port));
            socketChannel.close();
        }
    }

    private void finishConnection(SelectionKey key) throws IOException {
        AssociationImpl association = (AssociationImpl)key.attachment();
        if (association.getIpChannelType() == IpChannelType.SCTP) {
            this.finishConnectionSctp(key);
        } else {
            this.finishConnectionTcp(key);
        }
    }

    private void finishConnectionSctp(SelectionKey key) throws IOException {
        AssociationImpl association = (AssociationImpl)key.attachment();
        try {
            SctpChannel socketChannel = (SctpChannel)key.channel();
            if (socketChannel.isConnectionPending()) {
                while (socketChannel.isConnectionPending()) {
                    socketChannel.finishConnect();
                }
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)String.format("Association=%s connected to=%s", association.getName(), socketChannel.getRemoteAddresses()));
            }
            key.interestOps(1);
        }
        catch (Exception e) {
            logger.error((Object)String.format("Exception while finishing connection for Association=%s", association.getName()), (Throwable)e);
            association.scheduleConnect();
        }
    }

    private void finishConnectionTcp(SelectionKey key) throws IOException {
        AssociationImpl association = (AssociationImpl)key.attachment();
        try {
            SocketChannel socketChannel = (SocketChannel)key.channel();
            if (socketChannel.isConnectionPending()) {
                while (socketChannel.isConnectionPending()) {
                    socketChannel.finishConnect();
                }
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)String.format("Association=%s connected to=%s", association.getName(), socketChannel.getRemoteAddress()));
            }
            key.interestOps(1);
            AssociationChangeNotification.AssocChangeEvent ace = AssociationChangeNotification.AssocChangeEvent.COMM_UP;
            AssociationChangeNotification2 acn = new AssociationChangeNotification2(ace);
            association.associationHandler.handleNotification((AssociationChangeNotification)acn, association);
        }
        catch (Exception e) {
            logger.error((Object)String.format("Exception while finishing connection for Association=%s", association.getName()), (Throwable)e);
            association.scheduleConnect();
        }
    }

    private void read(SelectionKey key) throws IOException {
        AssociationImpl association = (AssociationImpl)key.attachment();
        association.read();
    }

    private void write(SelectionKey key) throws IOException {
        AssociationImpl association = (AssociationImpl)key.attachment();
        association.write(key);
    }

    class AssociationChangeNotification2
    extends AssociationChangeNotification {
        private AssociationChangeNotification.AssocChangeEvent assocChangeEvent;

        public AssociationChangeNotification2(AssociationChangeNotification.AssocChangeEvent assocChangeEvent) {
            this.assocChangeEvent = assocChangeEvent;
        }

        @Override
        public com.sun.nio.sctp.Association association() {
            return null;
        }

        @Override
        public AssociationChangeNotification.AssocChangeEvent event() {
            return this.assocChangeEvent;
        }
    }
}

