/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.sctp;

import com.sun.nio.sctp.AbstractNotificationHandler;
import com.sun.nio.sctp.AssociationChangeNotification;
import com.sun.nio.sctp.HandlerResult;
import com.sun.nio.sctp.PeerAddressChangeNotification;
import com.sun.nio.sctp.SendFailedNotification;
import com.sun.nio.sctp.ShutdownNotification;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.mobicents.protocols.api.Association;
import org.mobicents.protocols.sctp.AssociationImpl;

class AssociationHandler
extends AbstractNotificationHandler<AssociationImpl> {
    private static final Logger logger = Logger.getLogger(AssociationHandler.class);
    private volatile int maxInboundStreams = 1;
    private volatile int maxOutboundStreams = 1;

    public int getMaxInboundStreams() {
        return this.maxInboundStreams;
    }

    public int getMaxOutboundStreams() {
        return this.maxOutboundStreams;
    }

    @Override
    public HandlerResult handleNotification(AssociationChangeNotification not, AssociationImpl associtaion) {
        switch (not.event()) {
            case COMM_UP: {
                if (not.association() != null) {
                    this.maxOutboundStreams = not.association().maxOutboundStreams();
                    this.maxInboundStreams = not.association().maxInboundStreams();
                }
                if (logger.isInfoEnabled()) {
                    logger.info((Object)String.format("New association setup for Association=%s with %d outbound streams, and %d inbound streams.\n", associtaion.getName(), this.maxOutboundStreams, this.maxInboundStreams));
                }
                associtaion.createworkerThreadTable(Math.max(this.maxInboundStreams, this.maxOutboundStreams));
                try {
                    associtaion.markAssociationUp();
                    associtaion.getAssociationListener().onCommunicationUp((Association)associtaion, this.maxInboundStreams, this.maxOutboundStreams);
                }
                catch (Exception e) {
                    logger.error((Object)String.format("Exception while calling onCommunicationUp on AssociationListener for Association=%s", associtaion.getName()), (Throwable)e);
                }
                return HandlerResult.CONTINUE;
            }
            case CANT_START: {
                logger.error((Object)String.format("Can't start for Association=%s", associtaion.getName()));
                return HandlerResult.CONTINUE;
            }
            case COMM_LOST: {
                logger.warn((Object)String.format("Communication lost for Association=%s", associtaion.getName()));
                associtaion.close();
                associtaion.scheduleConnect();
                try {
                    associtaion.markAssociationDown();
                    associtaion.getAssociationListener().onCommunicationLost((Association)associtaion);
                }
                catch (Exception e) {
                    logger.error((Object)String.format("Exception while calling onCommunicationLost on AssociationListener for Association=%s", associtaion.getName()), (Throwable)e);
                }
                return HandlerResult.RETURN;
            }
            case RESTART: {
                logger.warn((Object)String.format("Restart for Association=%s", associtaion.getName()));
                try {
                    associtaion.getAssociationListener().onCommunicationRestart((Association)associtaion);
                }
                catch (Exception e) {
                    logger.error((Object)String.format("Exception while calling onCommunicationRestart on AssociationListener for Association=%s", associtaion.getName()), (Throwable)e);
                }
                return HandlerResult.CONTINUE;
            }
            case SHUTDOWN: {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)String.format("Shutdown for Association=%s", associtaion.getName()));
                }
                try {
                    associtaion.markAssociationDown();
                    associtaion.getAssociationListener().onCommunicationShutdown((Association)associtaion);
                }
                catch (Exception e) {
                    logger.error((Object)String.format("Exception while calling onCommunicationShutdown on AssociationListener for Association=%s", associtaion.getName()), (Throwable)e);
                }
                return HandlerResult.RETURN;
            }
        }
        logger.warn((Object)String.format("Received unkown Event=%s for Association=%s", new Object[]{not.event(), associtaion.getName()}));
        return HandlerResult.CONTINUE;
    }

    @Override
    public HandlerResult handleNotification(ShutdownNotification not, AssociationImpl associtaion) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)String.format("Association=%s SHUTDOWN", associtaion.getName()));
        }
        try {
            associtaion.markAssociationDown();
            associtaion.getAssociationListener().onCommunicationShutdown((Association)associtaion);
        }
        catch (Exception e) {
            logger.error((Object)String.format("Exception while calling onCommunicationShutdown on AssociationListener for Association=%s", associtaion.getName()), (Throwable)e);
        }
        return HandlerResult.RETURN;
    }

    @Override
    public HandlerResult handleNotification(SendFailedNotification notification, AssociationImpl associtaion) {
        logger.error((Object)String.format("Association=%s SendFailedNotification", associtaion.getName()));
        return HandlerResult.RETURN;
    }

    @Override
    public HandlerResult handleNotification(PeerAddressChangeNotification notification, AssociationImpl associtaion) {
        if (logger.isEnabledFor(Priority.WARN)) {
            logger.warn((Object)String.format("Peer Address changed to=%s for Association=%s", notification.address(), associtaion.getName()));
        }
        return HandlerResult.CONTINUE;
    }
}

