/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.api;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import org.mobicents.commons.HexTools;

public class PayloadData {
    private final int dataLength;
    private final ByteBuf byteBuf;
    private final boolean complete;
    private final boolean unordered;
    private final int payloadProtocolId;
    private final int streamNumber;

    public PayloadData(int dataLength, ByteBuf byteBuf, boolean complete, boolean unordered, int payloadProtocolId, int streamNumber) {
        this.dataLength = dataLength;
        this.byteBuf = byteBuf;
        this.complete = complete;
        this.unordered = unordered;
        this.payloadProtocolId = payloadProtocolId;
        this.streamNumber = streamNumber;
    }

    public PayloadData(int dataLength, byte[] data, boolean complete, boolean unordered, int payloadProtocolId, int streamNumber) {
        this.dataLength = dataLength;
        this.byteBuf = Unpooled.wrappedBuffer((byte[])data);
        this.complete = complete;
        this.unordered = unordered;
        this.payloadProtocolId = payloadProtocolId;
        this.streamNumber = streamNumber;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public ByteBuf getByteBuf() {
        return this.byteBuf;
    }

    public byte[] getData() {
        byte[] array = new byte[this.byteBuf.readableBytes()];
        this.byteBuf.getBytes(0, array);
        ReferenceCountUtil.release((Object)this.byteBuf);
        return array;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isUnordered() {
        return this.unordered;
    }

    public int getPayloadProtocolId() {
        return this.payloadProtocolId;
    }

    public int getStreamNumber() {
        return this.streamNumber;
    }

    public String toString() {
        byte[] array = new byte[this.byteBuf.readableBytes()];
        this.byteBuf.getBytes(0, array);
        StringBuffer sb = new StringBuffer();
        sb.append("PayloadData [dataLength=").append(this.dataLength).append(", complete=").append(this.complete).append(", unordered=").append(this.unordered).append(", payloadProtocolId=").append(this.payloadProtocolId).append(", streamNumber=").append(this.streamNumber).append(", data=\n").append(HexTools.dump((byte[])array, (int)0)).append("]");
        return sb.toString();
    }
}

