/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.mgcp.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.mobicents.protocols.mgcp.utils.PacketRepresentation;

public class PacketRepresentationFactory {
    private static final Logger logger = Logger.getLogger(PacketRepresentationFactory.class);
    private List<PacketRepresentation> list = new ArrayList<PacketRepresentation>();
    private int size = 0;
    private int dataArrSize = 0;
    private int count = 0;

    public PacketRepresentationFactory(int size, int dataArrSize) {
        this.size = size;
        this.dataArrSize = dataArrSize;
        for (int i = 0; i < size; ++i) {
            PacketRepresentation pr = new PacketRepresentation(dataArrSize, this);
            this.list.add(pr);
        }
    }

    public PacketRepresentation allocate() {
        PacketRepresentation pr = null;
        if (!this.list.isEmpty()) {
            pr = this.list.remove(0);
        }
        if (pr != null) {
            pr.setLength(0);
            return pr;
        }
        pr = new PacketRepresentation(this.dataArrSize, this);
        ++this.count;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("UtilsFactory underflow. Count = " + this.count));
        }
        logger.error((Object)("UtilsFactory underflow. Count = " + this.count));
        return pr;
    }

    public void deallocate(PacketRepresentation pr) {
        if (this.list.size() < this.size && pr != null) {
            this.list.add(pr);
        } else {
            System.out.println("Discarding the PR " + pr);
        }
    }

    public int getSize() {
        return this.size;
    }

    public int getDataArrSize() {
        return this.dataArrSize;
    }

    public int getCount() {
        return this.count;
    }
}

