/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.mgcp.stack;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.Notify;
import jain.protocol.ip.mgcp.message.NotifyResponse;
import jain.protocol.ip.mgcp.message.parms.EventName;
import jain.protocol.ip.mgcp.message.parms.RequestIdentifier;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.io.IOException;
import java.net.InetAddress;
import java.text.ParseException;
import org.apache.log4j.Logger;
import org.mobicents.protocols.mgcp.parser.MgcpContentHandler;
import org.mobicents.protocols.mgcp.parser.MgcpMessageParser;
import org.mobicents.protocols.mgcp.parser.Utils;
import org.mobicents.protocols.mgcp.stack.JainMgcpStackImpl;
import org.mobicents.protocols.mgcp.stack.TransactionHandler;

public class NotifyHandler
extends TransactionHandler {
    private Notify command;
    private NotifyResponse response;
    private static final Logger logger = Logger.getLogger(NotifyHandler.class);

    public NotifyHandler(JainMgcpStackImpl stack) {
        super(stack);
    }

    public NotifyHandler(JainMgcpStackImpl stack, InetAddress address, int port) {
        super(stack, address, port);
    }

    public JainMgcpCommandEvent decodeCommand(String message) throws ParseException {
        Utils utils = this.utilsFactory.allocate();
        MgcpMessageParser parser = new MgcpMessageParser(new CommandContentHandle(utils));
        try {
            parser.parse(message);
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage(), -1);
        }
        finally {
            this.utilsFactory.deallocate(utils);
        }
        return this.command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JainMgcpResponseEvent decodeResponse(String message) throws ParseException {
        Utils utils = this.utilsFactory.allocate();
        MgcpMessageParser parser = new MgcpMessageParser(new ResponseContentHandle(utils));
        try {
            parser.parse(message);
        }
        catch (IOException e) {
            logger.error((Object)"Something wrong while parsing the NOTIFY Response received", (Throwable)e);
        }
        finally {
            this.utilsFactory.deallocate(utils);
        }
        return this.response;
    }

    public String encode(JainMgcpCommandEvent event) {
        Notify notify = (Notify)event;
        StringBuffer message = new StringBuffer();
        message.append("NTFY ").append(event.getTransactionHandle()).append(" ").append(notify.getEndpointIdentifier()).append(" MGCP 1.0").append("\n");
        if (notify.getNotifiedEntity() != null) {
            message.append("N: ").append(notify.getNotifiedEntity()).append("\n");
        }
        message.append("X: ").append(notify.getRequestIdentifier()).append("\n");
        Utils utils = this.utilsFactory.allocate();
        message.append("O: ").append(utils.encodeEventNames(notify.getObservedEvents())).append("\n");
        this.utilsFactory.deallocate(utils);
        return message.toString();
    }

    public String encode(JainMgcpResponseEvent event) {
        StringBuffer s = new StringBuffer();
        s.append(event.getReturnCode().getValue()).append(" ").append(event.getTransactionHandle()).append(" ").append(event.getReturnCode().getComment()).append("\n");
        return s.toString();
    }

    public JainMgcpResponseEvent getProvisionalResponse() {
        NotifyResponse provisionalresponse = null;
        if (!this.sent) {
            provisionalresponse = new NotifyResponse(this.source != null ? this.source : this.stack, ReturnCode.Transaction_Being_Executed);
        }
        return provisionalresponse;
    }

    private class ResponseContentHandle
    implements MgcpContentHandler {
        private Utils utils;

        public ResponseContentHandle(Utils utils) {
            this.utils = utils;
        }

        public void header(String header) throws ParseException {
            String[] tokens = this.utils.splitStringBySpace(header);
            int tid = Integer.parseInt(tokens[1]);
            NotifyHandler.this.response = new NotifyResponse(NotifyHandler.this.source != null ? NotifyHandler.this.source : NotifyHandler.this.stack, this.utils.decodeReturnCode(Integer.parseInt(tokens[0])));
            NotifyHandler.this.response.setTransactionHandle(tid);
        }

        public void param(String name, String value) throws ParseException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void sessionDescription(String sd) throws ParseException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class CommandContentHandle
    implements MgcpContentHandler {
        private Utils utils = null;

        public CommandContentHandle(Utils utils) {
            this.utils = utils;
        }

        public void header(String header) throws ParseException {
            NotifyHandler.this.command = new Notify(NotifyHandler.this.source != null ? NotifyHandler.this.source : NotifyHandler.this.stack, NotifyHandler.this.endpoint, new RequestIdentifier("0"), new EventName[0]);
            NotifyHandler.this.command.setTransactionHandle(NotifyHandler.this.remoteTID);
        }

        public void param(String name, String value) throws ParseException {
            if (name.equalsIgnoreCase("N")) {
                NotifyHandler.this.command.setNotifiedEntity(this.utils.decodeNotifiedEntity(value, false));
            } else if (name.equalsIgnoreCase("X")) {
                NotifyHandler.this.command.setRequestIdentifier(new RequestIdentifier(value));
            } else if (name.equalsIgnoreCase("O")) {
                NotifyHandler.this.command.setObservedEvents(this.utils.decodeEventNames(value));
            }
        }

        public void sessionDescription(String sd) throws ParseException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

