/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.mgcp.stack;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.ModifyConnection;
import jain.protocol.ip.mgcp.message.ModifyConnectionResponse;
import jain.protocol.ip.mgcp.message.parms.CallIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionDescriptor;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.NotificationRequestParms;
import jain.protocol.ip.mgcp.message.parms.NotifiedEntity;
import jain.protocol.ip.mgcp.message.parms.RequestIdentifier;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.io.IOException;
import java.net.InetAddress;
import java.text.ParseException;
import org.apache.log4j.Logger;
import org.mobicents.protocols.mgcp.parser.MgcpContentHandler;
import org.mobicents.protocols.mgcp.parser.MgcpMessageParser;
import org.mobicents.protocols.mgcp.parser.Utils;
import org.mobicents.protocols.mgcp.stack.JainMgcpStackImpl;
import org.mobicents.protocols.mgcp.stack.TransactionHandler;

public class ModifyConnectionHandler
extends TransactionHandler {
    private ModifyConnection command = null;
    private ModifyConnectionResponse response = null;
    private static final Logger logger = Logger.getLogger(ModifyConnectionHandler.class);

    public ModifyConnectionHandler(JainMgcpStackImpl stack) {
        super(stack);
    }

    public ModifyConnectionHandler(JainMgcpStackImpl stack, InetAddress address, int port) {
        super(stack, address, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JainMgcpCommandEvent decodeCommand(String message) throws ParseException {
        Utils utils = this.utilsFactory.allocate();
        MgcpMessageParser parser = new MgcpMessageParser(new CommandContentHandle(utils));
        try {
            parser.parse(message);
        }
        catch (IOException e) {
            logger.error((Object)"Decoding of MDCX command failed", (Throwable)e);
        }
        finally {
            this.utilsFactory.deallocate(utils);
        }
        NotifiedEntity notifiedEntity = this.command.getNotifiedEntity();
        if (this.command.getNotifiedEntity() != null) {
            this.stack.provider.setNotifiedEntity(notifiedEntity);
        }
        return this.command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JainMgcpResponseEvent decodeResponse(String message) throws ParseException {
        Utils utils = this.utilsFactory.allocate();
        MgcpMessageParser parser = new MgcpMessageParser(new ResponseContentHandle(utils));
        try {
            parser.parse(message);
        }
        catch (IOException e) {
            logger.error((Object)"Decoding of MDCX Response failed", (Throwable)e);
        }
        finally {
            this.utilsFactory.deallocate(utils);
        }
        return this.response;
    }

    public String encode(JainMgcpCommandEvent event) {
        Utils utils = this.utilsFactory.allocate();
        ModifyConnection evt = (ModifyConnection)event;
        StringBuffer s = new StringBuffer();
        s.append("MDCX ").append(evt.getTransactionHandle()).append(" ").append(evt.getEndpointIdentifier()).append(" ").append(" MGCP 1.0").append("\n");
        s.append("C:").append(evt.getCallIdentifier()).append("\n");
        s.append("I:").append(evt.getConnectionIdentifier()).append("\n");
        if (evt.getBearerInformation() != null) {
            s.append("B:e:").append(evt.getBearerInformation()).append("\n");
        }
        if (evt.getLocalConnectionOptions() != null) {
            s.append("L:").append(utils.encodeLocalOptionValueList(evt.getLocalConnectionOptions()));
        }
        if (evt.getMode() != null) {
            s.append("M:").append(evt.getMode()).append("\n");
        }
        if (evt.getNotificationRequestParms() != null) {
            s.append(utils.encodeNotificationRequestParms(evt.getNotificationRequestParms()));
        }
        if (evt.getNotifiedEntity() != null) {
            s.append("N:").append(evt.getNotifiedEntity()).append("\n");
        }
        if (evt.getRemoteConnectionDescriptor() != null) {
            s.append("\n").append(evt.getRemoteConnectionDescriptor());
        }
        this.utilsFactory.deallocate(utils);
        return s.toString();
    }

    public String encode(JainMgcpResponseEvent event) {
        ModifyConnectionResponse response = (ModifyConnectionResponse)event;
        ReturnCode returnCode = response.getReturnCode();
        StringBuffer s = new StringBuffer();
        s.append(returnCode.getValue()).append(" ").append(response.getTransactionHandle()).append(" ").append(returnCode.getComment()).append("\n");
        if (response.getLocalConnectionDescriptor() != null) {
            s.append("\n").append(response.getLocalConnectionDescriptor());
        }
        return s.toString();
    }

    public JainMgcpResponseEvent getProvisionalResponse() {
        ModifyConnectionResponse provisionalresponse = null;
        if (!this.sent) {
            provisionalresponse = new ModifyConnectionResponse(this.source != null ? this.source : this.stack, ReturnCode.Transaction_Being_Executed);
        }
        return provisionalresponse;
    }

    private class ResponseContentHandle
    implements MgcpContentHandler {
        private Utils utils;

        public ResponseContentHandle(Utils utils) {
            this.utils = utils;
        }

        public void header(String header) throws ParseException {
            String[] tokens = this.utils.splitStringBySpace(header);
            int tid = Integer.parseInt(tokens[1]);
            ModifyConnectionHandler.this.response = new ModifyConnectionResponse(ModifyConnectionHandler.this.source != null ? ModifyConnectionHandler.this.source : ModifyConnectionHandler.this.stack, this.utils.decodeReturnCode(Integer.parseInt(tokens[0])));
            ModifyConnectionHandler.this.response.setTransactionHandle(tid);
        }

        public void param(String name, String value) throws ParseException {
        }

        public void sessionDescription(String sd) throws ParseException {
            ModifyConnectionHandler.this.response.setLocalConnectionDescriptor(new ConnectionDescriptor(sd));
        }
    }

    private class CommandContentHandle
    implements MgcpContentHandler {
        private Utils utils = null;

        public CommandContentHandle(Utils utils) {
            this.utils = utils;
        }

        public void header(String header) throws ParseException {
            ModifyConnectionHandler.this.command = new ModifyConnection(ModifyConnectionHandler.this.source != null ? ModifyConnectionHandler.this.source : ModifyConnectionHandler.this.stack, new CallIdentifier("00"), ModifyConnectionHandler.this.endpoint, new ConnectionIdentifier("00"));
            ModifyConnectionHandler.this.command.setTransactionHandle(ModifyConnectionHandler.this.remoteTID);
        }

        public void param(String name, String value) throws ParseException {
            if (name.equalsIgnoreCase("B")) {
                ModifyConnectionHandler.this.command.setBearerInformation(this.utils.decodeBearerInformation(value));
            } else if (name.equalsIgnoreCase("c")) {
                ModifyConnectionHandler.this.command.setCallIdentifier(new CallIdentifier(value));
            } else if (name.equalsIgnoreCase("I")) {
                ModifyConnectionHandler.this.command.setConnectionIdentifier(new ConnectionIdentifier(value));
            } else if (name.equalsIgnoreCase("m")) {
                ModifyConnectionHandler.this.command.setMode(this.utils.decodeConnectionMode(value));
            } else if (name.equalsIgnoreCase("L")) {
                ModifyConnectionHandler.this.command.setLocalConnectionOptions(this.utils.decodeLocalOptionValueList(value));
            } else if (name.equalsIgnoreCase("N")) {
                ModifyConnectionHandler.this.command.setNotifiedEntity(this.utils.decodeNotifiedEntity(value, true));
            } else if (name.equalsIgnoreCase("X")) {
                ModifyConnectionHandler.this.command.setNotificationRequestParms(new NotificationRequestParms(new RequestIdentifier(value)));
            } else if (name.equalsIgnoreCase("R")) {
                ModifyConnectionHandler.this.command.getNotificationRequestParms().setRequestedEvents(this.utils.decodeRequestedEventList(value));
            } else if (name.equalsIgnoreCase("S")) {
                ModifyConnectionHandler.this.command.getNotificationRequestParms().setSignalRequests(this.utils.decodeEventNames(value));
            } else if (name.equalsIgnoreCase("T")) {
                ModifyConnectionHandler.this.command.getNotificationRequestParms().setDetectEvents(this.utils.decodeEventNames(value));
            }
        }

        public void sessionDescription(String sd) throws ParseException {
            ModifyConnectionHandler.this.command.setRemoteConnectionDescriptor(new ConnectionDescriptor(sd));
        }
    }
}

