/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.mgcp.stack;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.EndpointConfiguration;
import jain.protocol.ip.mgcp.message.EndpointConfigurationResponse;
import jain.protocol.ip.mgcp.message.parms.BearerInformation;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.net.InetAddress;
import java.text.ParseException;
import org.apache.log4j.Logger;
import org.mobicents.protocols.mgcp.parser.MgcpContentHandler;
import org.mobicents.protocols.mgcp.parser.MgcpMessageParser;
import org.mobicents.protocols.mgcp.parser.Utils;
import org.mobicents.protocols.mgcp.stack.JainMgcpStackImpl;
import org.mobicents.protocols.mgcp.stack.TransactionHandler;

public class EndpointConfigurationHandler
extends TransactionHandler {
    private EndpointConfiguration command;
    private EndpointConfigurationResponse response;
    private static final Logger logger = Logger.getLogger(EndpointConfigurationHandler.class);

    public EndpointConfigurationHandler(JainMgcpStackImpl stack) {
        super(stack);
    }

    public EndpointConfigurationHandler(JainMgcpStackImpl stack, InetAddress address, int port) {
        super(stack, address, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JainMgcpCommandEvent decodeCommand(String message) throws ParseException {
        Utils utils = this.utilsFactory.allocate();
        MgcpMessageParser parser = new MgcpMessageParser(new CommandContentHandle(utils));
        try {
            parser.parse(message);
        }
        catch (Exception e) {
            logger.error((Object)"Parsing of EndpointConfiguration command failed", (Throwable)e);
        }
        finally {
            this.utilsFactory.deallocate(utils);
        }
        return this.command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JainMgcpResponseEvent decodeResponse(String message) throws ParseException {
        Utils utils = this.utilsFactory.allocate();
        MgcpMessageParser parser = new MgcpMessageParser(new ResponseContentHandle(utils));
        try {
            parser.parse(message);
        }
        catch (Exception e) {
            logger.error((Object)"Parsing of EndpointConfiguration Response failed", (Throwable)e);
        }
        finally {
            this.utilsFactory.deallocate(utils);
        }
        return this.response;
    }

    public String encode(JainMgcpCommandEvent event) {
        EndpointConfiguration evt = (EndpointConfiguration)event;
        StringBuffer s = new StringBuffer();
        s.append("EPCF ").append(evt.getTransactionHandle()).append(" ").append(evt.getEndpointIdentifier()).append(" MGCP 1.0").append("\n");
        s.append("B:e:").append(evt.getBearerInformation()).append("\n");
        return s.toString();
    }

    public String encode(JainMgcpResponseEvent event) {
        EndpointConfigurationResponse response = (EndpointConfigurationResponse)event;
        ReturnCode returnCode = response.getReturnCode();
        StringBuffer s = new StringBuffer();
        s.append(returnCode.getValue()).append(" ").append(response.getTransactionHandle()).append(" ").append(returnCode.getComment()).append("\n");
        return s.toString();
    }

    public JainMgcpResponseEvent getProvisionalResponse() {
        EndpointConfigurationResponse provisionalresponse = null;
        if (!this.sent) {
            provisionalresponse = new EndpointConfigurationResponse(this.source != null ? this.source : this.stack, ReturnCode.Transaction_Being_Executed);
        }
        return provisionalresponse;
    }

    private class ResponseContentHandle
    implements MgcpContentHandler {
        private Utils utils = null;

        public ResponseContentHandle(Utils utils) {
            this.utils = utils;
        }

        public void header(String header) throws ParseException {
            String[] tokens = this.utils.splitStringBySpace(header);
            int tid = Integer.parseInt(tokens[1]);
            EndpointConfigurationHandler.this.response = new EndpointConfigurationResponse(EndpointConfigurationHandler.this.source != null ? EndpointConfigurationHandler.this.source : EndpointConfigurationHandler.this.stack, this.utils.decodeReturnCode(Integer.parseInt(tokens[0])));
            EndpointConfigurationHandler.this.response.setTransactionHandle(tid);
        }

        public void param(String name, String value) throws ParseException {
        }

        public void sessionDescription(String sd) throws ParseException {
        }
    }

    private class CommandContentHandle
    implements MgcpContentHandler {
        private Utils utils = null;

        public CommandContentHandle(Utils utils) {
            this.utils = utils;
        }

        public void header(String header) throws ParseException {
            EndpointConfigurationHandler.this.command = new EndpointConfiguration(EndpointConfigurationHandler.this.source != null ? EndpointConfigurationHandler.this.source : EndpointConfigurationHandler.this.stack, EndpointConfigurationHandler.this.endpoint, BearerInformation.EncMethod_A_Law);
            EndpointConfigurationHandler.this.command.setTransactionHandle(EndpointConfigurationHandler.this.remoteTID);
        }

        public void param(String name, String value) throws ParseException {
            if (name.equalsIgnoreCase("B")) {
                EndpointConfigurationHandler.this.command.setBearerInformation(this.utils.decodeBearerInformation(value));
            }
        }

        public void sessionDescription(String sd) throws ParseException {
        }
    }
}

