/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.mgcp.stack;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.CreateConnection;
import jain.protocol.ip.mgcp.message.CreateConnectionResponse;
import jain.protocol.ip.mgcp.message.parms.CallIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConflictingParameterException;
import jain.protocol.ip.mgcp.message.parms.ConnectionDescriptor;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionMode;
import jain.protocol.ip.mgcp.message.parms.DigitMap;
import jain.protocol.ip.mgcp.message.parms.NotificationRequestParms;
import jain.protocol.ip.mgcp.message.parms.NotifiedEntity;
import jain.protocol.ip.mgcp.message.parms.RequestIdentifier;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.io.IOException;
import java.net.InetAddress;
import java.text.ParseException;
import org.apache.log4j.Logger;
import org.mobicents.protocols.mgcp.parser.MgcpContentHandler;
import org.mobicents.protocols.mgcp.parser.MgcpMessageParser;
import org.mobicents.protocols.mgcp.parser.Utils;
import org.mobicents.protocols.mgcp.stack.JainMgcpStackImpl;
import org.mobicents.protocols.mgcp.stack.TransactionHandler;

public class CreateConnectionHandler
extends TransactionHandler {
    private static final Logger logger = Logger.getLogger(CreateConnectionHandler.class);
    private CreateConnection command;
    private CreateConnectionResponse response;

    public CreateConnectionHandler(JainMgcpStackImpl stack) {
        super(stack);
    }

    public CreateConnectionHandler(JainMgcpStackImpl stack, InetAddress address, int port) {
        super(stack, address, port);
    }

    public JainMgcpCommandEvent decodeCommand(String message) throws ParseException {
        Utils utils = this.utilsFactory.allocate();
        MgcpMessageParser parser = new MgcpMessageParser(new CommandContentHandle(utils));
        try {
            parser.parse(message);
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage(), -1);
        }
        finally {
            this.utilsFactory.deallocate(utils);
        }
        NotifiedEntity notifiedEntity = this.command.getNotifiedEntity();
        if (this.command.getNotifiedEntity() != null) {
            this.stack.provider.setNotifiedEntity(notifiedEntity);
        }
        return this.command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JainMgcpResponseEvent decodeResponse(String message) throws ParseException {
        Utils utils = this.utilsFactory.allocate();
        MgcpMessageParser parser = new MgcpMessageParser(new ResponseContentHandle(utils));
        try {
            parser.parse(message);
        }
        catch (IOException e) {
            logger.error((Object)"Decode of CRCX Response failed ", (Throwable)e);
        }
        finally {
            this.utilsFactory.deallocate(utils);
        }
        return this.response;
    }

    public String encode(JainMgcpCommandEvent event) {
        Utils utils = this.utilsFactory.allocate();
        CreateConnection evt = (CreateConnection)event;
        StringBuffer s = new StringBuffer();
        s.append("CRCX ").append(evt.getTransactionHandle()).append(" ").append(evt.getEndpointIdentifier()).append(" MGCP 1.0").append("\n");
        s.append("C: ").append(evt.getCallIdentifier()).append("\n");
        s.append("M: ").append(evt.getMode()).append("\n");
        if (evt.getBearerInformation() != null) {
            s.append("B:e:").append(evt.getBearerInformation()).append("\n");
        }
        if (evt.getNotifiedEntity() != null) {
            s.append("N: ").append(evt.getNotifiedEntity()).append("\n");
        }
        if (evt.getLocalConnectionOptions() != null) {
            s.append("L: ").append(utils.encodeLocalOptionValueList(evt.getLocalConnectionOptions()));
        }
        if (evt.getSecondEndpointIdentifier() != null) {
            s.append("Z2: ").append(evt.getSecondEndpointIdentifier()).append("\n");
        }
        if (evt.getNotificationRequestParms() != null) {
            s.append(utils.encodeNotificationRequestParms(evt.getNotificationRequestParms()));
        }
        if (evt.getRemoteConnectionDescriptor() != null) {
            s.append("\n").append(evt.getRemoteConnectionDescriptor());
        }
        this.utilsFactory.deallocate(utils);
        return s.toString();
    }

    public String encode(JainMgcpResponseEvent event) {
        CreateConnectionResponse response = (CreateConnectionResponse)event;
        ReturnCode returnCode = response.getReturnCode();
        StringBuffer s = new StringBuffer();
        s.append(returnCode.getValue()).append(" ").append(response.getTransactionHandle()).append(" ").append(returnCode.getComment()).append("\n");
        if (response.getConnectionIdentifier() != null) {
            s.append("I: ").append(response.getConnectionIdentifier()).append("\n");
        }
        if (response.getSpecificEndpointIdentifier() != null) {
            s.append("Z: ").append(response.getSpecificEndpointIdentifier()).append("\n");
        }
        if (response.getSecondConnectionIdentifier() != null) {
            s.append("I2: ").append(response.getSecondConnectionIdentifier()).append("\n");
        }
        if (response.getSecondEndpointIdentifier() != null) {
            s.append("Z2: ").append(response.getSecondEndpointIdentifier()).append("\n");
        }
        if (response.getLocalConnectionDescriptor() != null) {
            s.append("\n").append(response.getLocalConnectionDescriptor());
        }
        return s.toString();
    }

    public JainMgcpResponseEvent getProvisionalResponse() {
        CreateConnectionResponse provisionalResponse = null;
        if (!this.sent) {
            ConnectionIdentifier connectionIdentifier = new ConnectionIdentifier("1");
            provisionalResponse = new CreateConnectionResponse(this.source != null ? this.source : this.stack, ReturnCode.Transaction_Being_Executed, connectionIdentifier);
            provisionalResponse.setTransactionHandle(this.remoteTID);
        }
        return provisionalResponse;
    }

    private class ResponseContentHandle
    implements MgcpContentHandler {
        private Utils utils = null;

        public ResponseContentHandle(Utils utils) {
            this.utils = utils;
        }

        public void header(String header) throws ParseException {
            String[] tokens = this.utils.splitStringBySpace(header);
            int tid = Integer.parseInt(tokens[1]);
            CreateConnectionHandler.this.response = new CreateConnectionResponse(CreateConnectionHandler.this.source != null ? CreateConnectionHandler.this.source : CreateConnectionHandler.this.stack, this.utils.decodeReturnCode(Integer.parseInt(tokens[0])), new ConnectionIdentifier("00"));
            CreateConnectionHandler.this.response.setTransactionHandle(tid);
        }

        public void param(String name, String value) throws ParseException {
            if (name.equalsIgnoreCase("I")) {
                CreateConnectionHandler.this.response.setConnectionIdentifier(new ConnectionIdentifier(value));
            } else if (name.equalsIgnoreCase("I2")) {
                CreateConnectionHandler.this.response.setSecondConnectionIdentifier(new ConnectionIdentifier(value));
            } else if (name.equalsIgnoreCase("Z")) {
                CreateConnectionHandler.this.response.setSpecificEndpointIdentifier(this.utils.decodeEndpointIdentifier(value));
            } else if (name.equalsIgnoreCase("Z2")) {
                CreateConnectionHandler.this.response.setSecondEndpointIdentifier(this.utils.decodeEndpointIdentifier(value));
            }
        }

        public void sessionDescription(String sd) throws ParseException {
            CreateConnectionHandler.this.response.setLocalConnectionDescriptor(new ConnectionDescriptor(sd));
        }
    }

    private class CommandContentHandle
    implements MgcpContentHandler {
        private Utils utils = null;

        public CommandContentHandle(Utils utils) {
            this.utils = utils;
        }

        public void header(String header) throws ParseException {
            CreateConnectionHandler.this.command = new CreateConnection(CreateConnectionHandler.this.source != null ? CreateConnectionHandler.this.source : CreateConnectionHandler.this.stack, new CallIdentifier("0"), CreateConnectionHandler.this.endpoint, ConnectionMode.Inactive);
            CreateConnectionHandler.this.command.setTransactionHandle(CreateConnectionHandler.this.remoteTID);
        }

        public void param(String name, String value) throws ParseException {
            if (name.equalsIgnoreCase("B")) {
                CreateConnectionHandler.this.command.setBearerInformation(this.utils.decodeBearerInformation(value));
            } else if (name.equalsIgnoreCase("c")) {
                CreateConnectionHandler.this.command.setCallIdentifier(new CallIdentifier(value));
            }
            if (name.equalsIgnoreCase("L")) {
                CreateConnectionHandler.this.command.setLocalConnectionOptions(this.utils.decodeLocalOptionValueList(value));
            } else if (name.equalsIgnoreCase("m")) {
                CreateConnectionHandler.this.command.setMode(this.utils.decodeConnectionMode(value));
            } else if (name.equalsIgnoreCase("N")) {
                CreateConnectionHandler.this.command.setNotifiedEntity(this.utils.decodeNotifiedEntity(value, true));
            } else if (name.equalsIgnoreCase("X")) {
                CreateConnectionHandler.this.command.setNotificationRequestParms(new NotificationRequestParms(new RequestIdentifier(value)));
            } else if (name.equalsIgnoreCase("D")) {
                CreateConnectionHandler.this.command.getNotificationRequestParms().setDigitMap(new DigitMap(value));
            } else if (name.equalsIgnoreCase("R")) {
                CreateConnectionHandler.this.command.getNotificationRequestParms().setRequestedEvents(this.utils.decodeRequestedEventList(value));
            } else if (name.equalsIgnoreCase("S")) {
                CreateConnectionHandler.this.command.getNotificationRequestParms().setSignalRequests(this.utils.decodeEventNames(value));
            } else if (name.equalsIgnoreCase("T")) {
                CreateConnectionHandler.this.command.getNotificationRequestParms().setDetectEvents(this.utils.decodeEventNames(value));
            } else if (name.equalsIgnoreCase("Z2")) {
                try {
                    CreateConnectionHandler.this.command.setSecondEndpointIdentifier(this.utils.decodeEndpointIdentifier(value));
                }
                catch (ConflictingParameterException conflictingParameterException) {
                    // empty catch block
                }
            }
        }

        public void sessionDescription(String sd) throws ParseException {
            try {
                CreateConnectionHandler.this.command.setRemoteConnectionDescriptor(new ConnectionDescriptor(sd));
            }
            catch (Exception e) {
                logger.error((Object)"Unexpected error in session descriptor", (Throwable)e);
            }
        }
    }
}

